/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ClassifyDocumentOptions
implements JsonSerializable<ClassifyDocumentOptions> {
    private StringIndexType stringIndexType;
    private SplitMode split;
    private List<String> pages;
    private String urlSource;
    private byte[] bytesSource;

    ClassifyDocumentOptions() {
    }

    public ClassifyDocumentOptions(String urlSource) {
        this.urlSource = urlSource;
    }

    public ClassifyDocumentOptions(byte[] bytesSource) {
        this.bytesSource = bytesSource;
    }

    public ClassifyDocumentOptions(BinaryData binaryData) {
        if (binaryData != null) {
            this.bytesSource = binaryData.toBytes();
        }
    }

    public String getUrlSource() {
        return this.urlSource;
    }

    public byte[] getBytesSource() {
        return CoreUtils.clone((byte[])this.bytesSource);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("urlSource", this.urlSource);
        jsonWriter.writeBinaryField("base64Source", this.bytesSource);
        return jsonWriter.writeEndObject();
    }

    public static ClassifyDocumentOptions fromJson(JsonReader jsonReader) throws IOException {
        return (ClassifyDocumentOptions)jsonReader.readObject(reader -> {
            ClassifyDocumentOptions deserializedClassifyDocumentOptions = new ClassifyDocumentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("urlSource".equals(fieldName)) {
                    deserializedClassifyDocumentOptions.urlSource = reader.getString();
                    continue;
                }
                if ("base64Source".equals(fieldName)) {
                    deserializedClassifyDocumentOptions.bytesSource = reader.getBinary();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClassifyDocumentOptions;
        });
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public ClassifyDocumentOptions setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    public SplitMode getSplit() {
        return this.split;
    }

    public ClassifyDocumentOptions setSplit(SplitMode split) {
        this.split = split;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public ClassifyDocumentOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    ClassifyDocumentOptions setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    ClassifyDocumentOptions setBytesSource(byte[] bytesSource) {
        this.bytesSource = CoreUtils.clone((byte[])bytesSource);
        return this;
    }
}

