/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.implementation.AnalyzeOperationDetailsHelper;
import com.azure.ai.documentintelligence.implementation.PollingUtils;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.OperationResourcePollingStrategy;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class OperationLocationPollingStrategy<T, U>
extends OperationResourcePollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(OperationLocationPollingStrategy.class);
    private final ObjectSerializer serializer;
    private final String endpoint;
    private final String propertyName;

    public OperationLocationPollingStrategy(PollingStrategyOptions pollingStrategyOptions) {
        this(pollingStrategyOptions, null);
    }

    public OperationLocationPollingStrategy(PollingStrategyOptions pollingStrategyOptions, String propertyName) {
        super(PollingUtils.OPERATION_LOCATION_HEADER, pollingStrategyOptions);
        this.propertyName = propertyName;
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : JsonSerializerProviders.createInstance((boolean)true);
    }

    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(PollingUtils.OPERATION_LOCATION_HEADER);
        if (operationLocationHeader != null) {
            pollingContext.setData(PollingUtils.OPERATION_LOCATION_HEADER.getCaseSensitiveName(), PollingUtils.getAbsolutePath(operationLocationHeader.getValue(), this.endpoint, LOGGER));
        }
        String httpMethod = response.getRequest().getHttpMethod().name();
        pollingContext.setData("httpMethod", httpMethod);
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = PollingUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            Mono pollResponseMono = PollingUtils.deserializeResponse((BinaryData)response.getValue(), this.serializer, pollResponseType).onErrorResume(exception -> {
                LOGGER.info("Failed to parse initial response.");
                return Mono.empty();
            }).map(value -> new PollResponse(LongRunningOperationStatus.IN_PROGRESS, value, retryAfter));
            return pollResponseMono.switchIfEmpty(Mono.fromSupplier(() -> new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter)));
        }
        return Mono.error((Throwable)new AzureException(String.format("Operation failed or cancelled with status code %d,, '%s' header: %s, and response body: %s", response.getStatusCode(), PollingUtils.OPERATION_LOCATION_HEADER, operationLocationHeader, response.getValue())));
    }

    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error((Throwable)new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error((Throwable)new AzureException("Long running operation cancelled."));
        }
        if (this.propertyName != null) {
            BinaryData latestResponseBody = BinaryData.fromString((String)pollingContext.getData("pollResponseBody"));
            return PollingUtils.deserializeResponse(latestResponseBody, this.serializer, PollingUtils.POST_POLL_RESULT_TYPE_REFERENCE).flatMap(value -> {
                if (value.get(this.propertyName) != null) {
                    return BinaryData.fromObjectAsync(value.get(this.propertyName)).flatMap(result -> PollingUtils.deserializeResponse(result, this.serializer, resultType));
                }
                return Mono.error((Throwable)new AzureException("Cannot get final result"));
            }).switchIfEmpty(Mono.error((Throwable)new AzureException("Cannot get final result")));
        }
        return super.getResult(pollingContext, resultType);
    }

    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return super.poll(pollingContext, pollResponseType).map(pollResponse -> {
            String operationLocationHeader = pollingContext.getData(String.valueOf(PollingUtils.OPERATION_LOCATION_HEADER));
            String operationId = null;
            if (operationLocationHeader != null) {
                operationId = PollingUtils.parseOperationId(operationLocationHeader);
            }
            if (pollResponse.getValue() instanceof AnalyzeOperationDetails) {
                AnalyzeOperationDetails operation = (AnalyzeOperationDetails)pollResponse.getValue();
                AnalyzeOperationDetailsHelper.setOperationId(operation, operationId);
            }
            return pollResponse;
        });
    }
}

