/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentField;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class Document
implements JsonSerializable<Document> {
    private final String docType;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private Map<String, DocumentField> fields;
    private final double confidence;

    private Document(String docType, List<DocumentSpan> spans, double confidence) {
        this.docType = docType;
        this.spans = spans;
        this.confidence = confidence;
    }

    public String getDocType() {
        return this.docType;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public Map<String, DocumentField> getFields() {
        return this.fields;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("docType", this.docType);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Document fromJson(JsonReader jsonReader) throws IOException {
        return (Document)jsonReader.readObject(reader -> {
            String docType = null;
            List spans = null;
            double confidence = 0.0;
            List boundingRegions = null;
            Map fields = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("docType".equals(fieldName)) {
                    docType = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            Document deserializedDocument = new Document(docType, spans, confidence);
            deserializedDocument.boundingRegions = boundingRegions;
            deserializedDocument.fields = fields;
            return deserializedDocument;
        });
    }
}

