/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.ContentFormat;
import com.azure.ai.documentintelligence.models.Document;
import com.azure.ai.documentintelligence.models.DocumentFigure;
import com.azure.ai.documentintelligence.models.DocumentKeyValuePair;
import com.azure.ai.documentintelligence.models.DocumentLanguage;
import com.azure.ai.documentintelligence.models.DocumentPage;
import com.azure.ai.documentintelligence.models.DocumentParagraph;
import com.azure.ai.documentintelligence.models.DocumentSection;
import com.azure.ai.documentintelligence.models.DocumentStyle;
import com.azure.ai.documentintelligence.models.DocumentTable;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.ai.documentintelligence.models.Warning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AnalyzeResult
implements JsonSerializable<AnalyzeResult> {
    private final String apiVersion;
    private final String modelId;
    private final StringIndexType stringIndexType;
    private ContentFormat contentFormat;
    private final String content;
    private final List<DocumentPage> pages;
    private List<DocumentParagraph> paragraphs;
    private List<DocumentTable> tables;
    private List<DocumentFigure> figures;
    private List<DocumentSection> sections;
    private List<DocumentKeyValuePair> keyValuePairs;
    private List<DocumentStyle> styles;
    private List<DocumentLanguage> languages;
    private List<Document> documents;
    private List<Warning> warnings;

    private AnalyzeResult(String apiVersion, String modelId, StringIndexType stringIndexType, String content, List<DocumentPage> pages) {
        this.apiVersion = apiVersion;
        this.modelId = modelId;
        this.stringIndexType = stringIndexType;
        this.content = content;
        this.pages = pages;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getModelId() {
        return this.modelId;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public ContentFormat getContentFormat() {
        return this.contentFormat;
    }

    public String getContent() {
        return this.content;
    }

    public List<DocumentPage> getPages() {
        return this.pages;
    }

    public List<DocumentParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public List<DocumentTable> getTables() {
        return this.tables;
    }

    public List<DocumentFigure> getFigures() {
        return this.figures;
    }

    public List<DocumentSection> getSections() {
        return this.sections;
    }

    public List<DocumentKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public List<DocumentStyle> getStyles() {
        return this.styles;
    }

    public List<DocumentLanguage> getLanguages() {
        return this.languages;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("contentFormat", this.contentFormat == null ? null : this.contentFormat.toString());
        jsonWriter.writeArrayField("paragraphs", this.paragraphs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("figures", this.figures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("keyValuePairs", this.keyValuePairs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("styles", this.styles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("languages", this.languages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResult)jsonReader.readObject(reader -> {
            String apiVersion = null;
            String modelId = null;
            StringIndexType stringIndexType = null;
            String content = null;
            List pages = null;
            ContentFormat contentFormat = null;
            List paragraphs = null;
            List tables = null;
            List figures = null;
            List sections = null;
            List keyValuePairs = null;
            List styles = null;
            List languages = null;
            List documents = null;
            List warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("pages".equals(fieldName)) {
                    pages = reader.readArray(reader1 -> DocumentPage.fromJson(reader1));
                    continue;
                }
                if ("contentFormat".equals(fieldName)) {
                    contentFormat = ContentFormat.fromString(reader.getString());
                    continue;
                }
                if ("paragraphs".equals(fieldName)) {
                    paragraphs = reader.readArray(reader1 -> DocumentParagraph.fromJson(reader1));
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    tables = reader.readArray(reader1 -> DocumentTable.fromJson(reader1));
                    continue;
                }
                if ("figures".equals(fieldName)) {
                    figures = reader.readArray(reader1 -> DocumentFigure.fromJson(reader1));
                    continue;
                }
                if ("sections".equals(fieldName)) {
                    sections = reader.readArray(reader1 -> DocumentSection.fromJson(reader1));
                    continue;
                }
                if ("keyValuePairs".equals(fieldName)) {
                    keyValuePairs = reader.readArray(reader1 -> DocumentKeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("styles".equals(fieldName)) {
                    styles = reader.readArray(reader1 -> DocumentStyle.fromJson(reader1));
                    continue;
                }
                if ("languages".equals(fieldName)) {
                    languages = reader.readArray(reader1 -> DocumentLanguage.fromJson(reader1));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    documents = reader.readArray(reader1 -> Document.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> Warning.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeResult deserializedAnalyzeResult = new AnalyzeResult(apiVersion, modelId, stringIndexType, content, pages);
            deserializedAnalyzeResult.contentFormat = contentFormat;
            deserializedAnalyzeResult.paragraphs = paragraphs;
            deserializedAnalyzeResult.tables = tables;
            deserializedAnalyzeResult.figures = figures;
            deserializedAnalyzeResult.sections = sections;
            deserializedAnalyzeResult.keyValuePairs = keyValuePairs;
            deserializedAnalyzeResult.styles = styles;
            deserializedAnalyzeResult.languages = languages;
            deserializedAnalyzeResult.documents = documents;
            deserializedAnalyzeResult.warnings = warnings;
            return deserializedAnalyzeResult;
        });
    }
}

