/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentBuildMode;
import com.azure.ai.documentintelligence.models.DocumentFieldSchema;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class DocumentTypeDetails
implements JsonSerializable<DocumentTypeDetails> {
    private String description;
    private DocumentBuildMode buildMode;
    private final Map<String, DocumentFieldSchema> fieldSchema;
    private Map<String, Double> fieldConfidence;

    private DocumentTypeDetails(Map<String, DocumentFieldSchema> fieldSchema) {
        this.fieldSchema = fieldSchema;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public Map<String, DocumentFieldSchema> getFieldSchema() {
        return this.fieldSchema;
    }

    public Map<String, Double> getFieldConfidence() {
        return this.fieldConfidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("fieldSchema", this.fieldSchema, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeMapField("fieldConfidence", this.fieldConfidence, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentTypeDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTypeDetails)jsonReader.readObject(reader -> {
            Map fieldSchema = null;
            String description = null;
            DocumentBuildMode buildMode = null;
            Map fieldConfidence = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldSchema".equals(fieldName)) {
                    fieldSchema = reader.readMap(reader1 -> DocumentFieldSchema.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    buildMode = DocumentBuildMode.fromString(reader.getString());
                    continue;
                }
                if ("fieldConfidence".equals(fieldName)) {
                    fieldConfidence = reader.readMap(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentTypeDetails deserializedDocumentTypeDetails = new DocumentTypeDetails(fieldSchema);
            deserializedDocumentTypeDetails.description = description;
            deserializedDocumentTypeDetails.buildMode = buildMode;
            deserializedDocumentTypeDetails.fieldConfidence = fieldConfidence;
            return deserializedDocumentTypeDetails;
        });
    }
}

