/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

final class PollingUtils {
    public static final TypeReference<Map<String, Object>> POST_POLL_RESULT_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    public static final HttpHeaderName OPERATION_LOCATION_HEADER = HttpHeaderName.fromString((String)"Operation-Location");
    public static final String HTTP_METHOD = "httpMethod";
    public static final String REQUEST_URL = "requestURL";
    public static final String POLL_RESPONSE_BODY = "pollResponseBody";
    private static final String FORWARD_SLASH = "/";
    private static final HttpHeaderName RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString((String)"retry-after-ms");
    private static final HttpHeaderName X_MS_RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString((String)"x-ms-retry-after-ms");

    PollingUtils() {
    }

    public static String getAbsolutePath(String path, String endpoint, ClientLogger logger) {
        try {
            URI uri = new URI(path);
            if (!uri.isAbsolute()) {
                if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
                    throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Relative path requires endpoint to be non-null and non-empty to create an absolute path."));
                }
                if (endpoint.endsWith(FORWARD_SLASH) && path.startsWith(FORWARD_SLASH)) {
                    return endpoint + path.substring(1);
                }
                if (!endpoint.endsWith(FORWARD_SLASH) && !path.startsWith(FORWARD_SLASH)) {
                    return endpoint + FORWARD_SLASH + path;
                }
                return endpoint + path;
            }
        }
        catch (URISyntaxException ex) {
            throw logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'path' must be a valid URI.", ex));
        }
        return path;
    }

    public static <T> T deserializeResponseSync(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        Object value = binaryData == null ? null : (typeReference.getJavaClass().isAssignableFrom(BinaryData.class) ? typeReference.getJavaClass().cast(binaryData.toReplayableBinaryData()) : binaryData.toObject(typeReference, serializer));
        return (T)value;
    }

    public static <T> Mono<T> deserializeResponse(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        Mono value = binaryData == null ? Mono.empty() : (typeReference.getJavaClass().isAssignableFrom(BinaryData.class) ? binaryData.toReplayableBinaryDataAsync() : binaryData.toObjectAsync(typeReference, serializer));
        return value;
    }

    public static Duration getRetryAfterFromHeaders(HttpHeaders headers, Supplier<OffsetDateTime> nowSupplier) {
        Duration retryDelay = PollingUtils.tryGetRetryDelay(headers, X_MS_RETRY_AFTER_MS_HEADER, s -> PollingUtils.tryGetDelayMillis(s));
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = PollingUtils.tryGetRetryDelay(headers, RETRY_AFTER_MS_HEADER, s -> PollingUtils.tryGetDelayMillis(s));
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = PollingUtils.tryGetRetryDelay(headers, HttpHeaderName.RETRY_AFTER, headerValue -> PollingUtils.tryParseLongOrDateTime(headerValue, nowSupplier));
        return retryDelay;
    }

    private static Duration tryGetRetryDelay(HttpHeaders headers, HttpHeaderName headerName, Function<String, Duration> delayParser) {
        String headerValue = headers.getValue(headerName);
        return CoreUtils.isNullOrEmpty((CharSequence)headerValue) ? null : delayParser.apply(headerValue);
    }

    private static Duration tryParseLongOrDateTime(String value, Supplier<OffsetDateTime> nowSupplier) {
        long delaySeconds;
        try {
            OffsetDateTime retryAfter = new DateTimeRfc1123(value).getDateTime();
            delaySeconds = nowSupplier.get().until(retryAfter, ChronoUnit.SECONDS);
        }
        catch (DateTimeException ex) {
            delaySeconds = PollingUtils.tryParseLong(value);
        }
        return delaySeconds >= 0L ? Duration.ofSeconds(delaySeconds) : null;
    }

    private static long tryParseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private static Duration tryGetDelayMillis(String value) {
        long delayMillis = PollingUtils.tryParseLong(value);
        return delayMillis >= 0L ? Duration.ofMillis(delayMillis) : null;
    }
}

