/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceAdministrationClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceAdministrationClientImpl;
import com.azure.ai.documentintelligence.models.AuthorizeCopyRequest;
import com.azure.ai.documentintelligence.models.BuildDocumentClassifierRequest;
import com.azure.ai.documentintelligence.models.BuildDocumentModelRequest;
import com.azure.ai.documentintelligence.models.ComposeDocumentModelRequest;
import com.azure.ai.documentintelligence.models.CopyAuthorization;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.OperationDetails;
import com.azure.ai.documentintelligence.models.ResourceDetails;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;

@ServiceClient(builder=DocumentIntelligenceAdministrationClientBuilder.class)
public final class DocumentIntelligenceAdministrationClient {
    private final DocumentIntelligenceAdministrationClientImpl serviceClient;

    DocumentIntelligenceAdministrationClient(DocumentIntelligenceAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildDocumentModel(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginComposeModel(composeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeModelCopyWithResponse(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyModelTo(modelId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getModelWithResponse(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listModels(RequestOptions requestOptions) {
        return this.serviceClient.listModels(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteModelWithResponse(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getResourceInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getResourceInfoWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponse(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildClassifier(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.getClassifierWithResponse(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listClassifiers(RequestOptions requestOptions) {
        return this.serviceClient.listClassifiers(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.deleteClassifierWithResponse(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModel(BuildDocumentModelRequest buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildDocumentModelWithModel(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModel(ComposeDocumentModelRequest composeRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginComposeModelWithModel(BinaryData.fromObject((Object)composeRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization authorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return (CopyAuthorization)((BinaryData)this.authorizeModelCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).getValue()).toObject(CopyAuthorization.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyModelToWithModel(modelId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentModelDetails)((BinaryData)this.getModelWithResponse(modelId, requestOptions).getValue()).toObject(DocumentModelDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelDetails> listModels() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listModels(requestOptions).mapPage(bodyItemValue -> (DocumentModelDetails)bodyItemValue.toObject(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteModelWithResponse(modelId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceDetails getResourceInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return (ResourceDetails)((BinaryData)this.getResourceInfoWithResponse(requestOptions).getValue()).toObject(ResourceDetails.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        RequestOptions requestOptions = new RequestOptions();
        return (OperationDetails)((BinaryData)this.getOperationWithResponse(operationId, requestOptions).getValue()).toObject(OperationDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationDetails> listOperations() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listOperations(requestOptions).mapPage(bodyItemValue -> (OperationDetails)bodyItemValue.toObject(OperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifier(BuildDocumentClassifierRequest buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildClassifierWithModel(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentClassifierDetails getClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return (DocumentClassifierDetails)((BinaryData)this.getClassifierWithResponse(classifierId, requestOptions).getValue()).toObject(DocumentClassifierDetails.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listClassifiers(requestOptions).mapPage(bodyItemValue -> (DocumentClassifierDetails)bodyItemValue.toObject(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteClassifierWithResponse(classifierId, requestOptions).getValue();
    }
}

