// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Table cell kind.
 */
public final class DocumentTableCellKind extends ExpandableStringEnum<DocumentTableCellKind> {
    /**
     * Contains the main content/data.
     */
    @Generated
    public static final DocumentTableCellKind CONTENT = fromString("content");

    /**
     * Describes the content of the row.
     */
    @Generated
    public static final DocumentTableCellKind ROW_HEADER = fromString("rowHeader");

    /**
     * Describes the content of the column.
     */
    @Generated
    public static final DocumentTableCellKind COLUMN_HEADER = fromString("columnHeader");

    /**
     * Describes the row headers, usually located at the top left corner of a table.
     */
    @Generated
    public static final DocumentTableCellKind STUB_HEAD = fromString("stubHead");

    /**
     * Describes the content in (parts of) the table.
     */
    @Generated
    public static final DocumentTableCellKind DESCRIPTION = fromString("description");

    /**
     * Creates a new instance of DocumentTableCellKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentTableCellKind() {
    }

    /**
     * Creates or finds a DocumentTableCellKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DocumentTableCellKind.
     */
    @Generated
    @JsonCreator
    public static DocumentTableCellKind fromString(String name) {
        return fromString(name, DocumentTableCellKind.class);
    }

    /**
     * Gets known DocumentTableCellKind values.
     * 
     * @return known DocumentTableCellKind values.
     */
    @Generated
    public static Collection<DocumentTableCellKind> values() {
        return values(DocumentTableCellKind.class);
    }
}
