// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Contiguous region of the concatenated content property, specified as an offset
 * and length.
 */
@Immutable
public final class DocumentSpan {
    /*
     * Zero-based index of the content represented by the span.
     */
    @Generated
    @JsonProperty(value = "offset")
    private int offset;

    /*
     * Number of characters in the content represented by the span.
     */
    @Generated
    @JsonProperty(value = "length")
    private int length;

    /**
     * Creates an instance of DocumentSpan class.
     * 
     * @param offset the offset value to set.
     * @param length the length value to set.
     */
    @Generated
    @JsonCreator
    private DocumentSpan(@JsonProperty(value = "offset") int offset, @JsonProperty(value = "length") int length) {
        this.offset = offset;
        this.length = length;
    }

    /**
     * Get the offset property: Zero-based index of the content represented by the span.
     * 
     * @return the offset value.
     */
    @Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Get the length property: Number of characters in the content represented by the span.
     * 
     * @return the length value.
     */
    @Generated
    public int getLength() {
        return this.length;
    }
}
