// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object representing a section in the document.
 */
@Immutable
public final class DocumentSection {
    /*
     * Location of the section in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Child elements of the section.
     */
    @Generated
    @JsonProperty(value = "elements")
    private List<String> elements;

    /**
     * Creates an instance of DocumentSection class.
     * 
     * @param spans the spans value to set.
     */
    @Generated
    @JsonCreator
    private DocumentSection(@JsonProperty(value = "spans") List<DocumentSpan> spans) {
        this.spans = spans;
    }

    /**
     * Get the spans property: Location of the section in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the elements property: Child elements of the section.
     * 
     * @return the elements value.
     */
    @Generated
    public List<String> getElements() {
        return this.elements;
    }
}
