// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Document model info.
 */
@Immutable
public final class DocumentModelDetails {
    /*
     * Unique document model name.
     */
    @Generated
    @JsonProperty(value = "modelId", access = JsonProperty.Access.WRITE_ONLY)
    private String modelId;

    /*
     * Document model description.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * Date and time (UTC) when the document model was created.
     */
    @Generated
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the document model will expire.
     */
    @Generated
    @JsonProperty(value = "expirationDateTime")
    private OffsetDateTime expirationDateTime;

    /*
     * API version used to create this document model.
     */
    @Generated
    @JsonProperty(value = "apiVersion")
    private String apiVersion;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * Custom document model build mode.
     */
    @Generated
    @JsonProperty(value = "buildMode")
    private DocumentBuildMode buildMode;

    /*
     * Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobSource")
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobFileListSource")
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /*
     * Supported document types.
     */
    @Generated
    @JsonProperty(value = "docTypes")
    private Map<String, DocumentTypeDetails> docTypes;

    /**
     * Creates an instance of DocumentModelDetails class.
     * 
     * @param createdDateTime the createdDateTime value to set.
     */
    @Generated
    @JsonCreator
    private DocumentModelDetails(@JsonProperty(value = "createdDateTime") OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    /**
     * Get the modelId property: Unique document model name.
     * 
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the document model was created.
     * 
     * @return the createdDateTime value.
     */
    @Generated
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the expirationDateTime property: Date and time (UTC) when the document model will expire.
     * 
     * @return the expirationDateTime value.
     */
    @Generated
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Get the apiVersion property: API version used to create this document model.
     * 
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     * 
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Get the docTypes property: Supported document types.
     * 
     * @return the docTypes value.
     */
    @Generated
    public Map<String, DocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }
}
