// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Custom document model build mode.
 */
public final class DocumentBuildMode extends ExpandableStringEnum<DocumentBuildMode> {
    /**
     * Target documents with similar visual templates.
     */
    @Generated
    public static final DocumentBuildMode TEMPLATE = fromString("template");

    /**
     * Support documents with diverse visual templates.
     */
    @Generated
    public static final DocumentBuildMode NEURAL = fromString("neural");

    /**
     * Creates a new instance of DocumentBuildMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentBuildMode() {
    }

    /**
     * Creates or finds a DocumentBuildMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DocumentBuildMode.
     */
    @Generated
    @JsonCreator
    public static DocumentBuildMode fromString(String name) {
        return fromString(name, DocumentBuildMode.class);
    }

    /**
     * Gets known DocumentBuildMode values.
     * 
     * @return known DocumentBuildMode values.
     */
    @Generated
    public static Collection<DocumentBuildMode> values() {
        return values(DocumentBuildMode.class);
    }
}
