// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Currency field value.
 */
@Immutable
public final class CurrencyValue {
    /*
     * Currency amount.
     */
    @Generated
    @JsonProperty(value = "amount")
    private double amount;

    /*
     * Currency symbol label, if any.
     */
    @Generated
    @JsonProperty(value = "currencySymbol")
    private String currencySymbol;

    /*
     * Resolved currency code (ISO 4217), if any.
     */
    @Generated
    @JsonProperty(value = "currencyCode")
    private String currencyCode;

    /**
     * Creates an instance of CurrencyValue class.
     * 
     * @param amount the amount value to set.
     */
    @Generated
    @JsonCreator
    private CurrencyValue(@JsonProperty(value = "amount") double amount) {
        this.amount = amount;
    }

    /**
     * Get the amount property: Currency amount.
     * 
     * @return the amount value.
     */
    @Generated
    public double getAmount() {
        return this.amount;
    }

    /**
     * Get the currencySymbol property: Currency symbol label, if any.
     * 
     * @return the currencySymbol value.
     */
    @Generated
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    /**
     * Get the currencyCode property: Resolved currency code (ISO 4217), if any.
     * 
     * @return the currencyCode value.
     */
    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }
}
