// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Type of content source.
 */
public final class ContentSourceKind extends ExpandableStringEnum<ContentSourceKind> {
    /**
     * Content at a specific URL.
     */
    @Generated
    public static final ContentSourceKind URL = fromString("url");

    /**
     * Content represented via Base64 encoding.
     */
    @Generated
    public static final ContentSourceKind BASE64 = fromString("base64");

    /**
     * Files in a path within an Azure Blob Storage container.
     */
    @Generated
    public static final ContentSourceKind AZURE_BLOB = fromString("azureBlob");

    /**
     * A file list specifying individual files in an Azure Blob Storage container.
     */
    @Generated
    public static final ContentSourceKind AZURE_BLOB_FILE_LIST = fromString("azureBlobFileList");

    /**
     * Creates a new instance of ContentSourceKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ContentSourceKind() {
    }

    /**
     * Creates or finds a ContentSourceKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContentSourceKind.
     */
    @Generated
    @JsonCreator
    public static ContentSourceKind fromString(String name) {
        return fromString(name, ContentSourceKind.class);
    }

    /**
     * Gets known ContentSourceKind values.
     * 
     * @return known ContentSourceKind values.
     */
    @Generated
    public static Collection<ContentSourceKind> values() {
        return values(ContentSourceKind.class);
    }
}
