// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Classifier document type info.
 */
@Fluent
public final class ClassifierDocumentTypeDetails {
    /*
     * Type of training data source.
     */
    @Generated
    @JsonProperty(value = "sourceKind")
    private ContentSourceKind sourceKind;

    /*
     * Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobSource")
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobFileListSource")
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /**
     * Creates an instance of ClassifierDocumentTypeDetails class.
     */
    @Generated
    public ClassifierDocumentTypeDetails() {
    }

    /**
     * Get the sourceKind property: Type of training data source.
     * 
     * @return the sourceKind value.
     */
    @Generated
    public ContentSourceKind getSourceKind() {
        return this.sourceKind;
    }

    /**
     * Set the sourceKind property: Type of training data source.
     * 
     * @param sourceKind the sourceKind value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails setSourceKind(ContentSourceKind sourceKind) {
        this.sourceKind = sourceKind;
        return this;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     * 
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     * 
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     * 
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Set the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     * 
     * @param azureBlobFileListSource the azureBlobFileListSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails
        setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }
}
