// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure Blob Storage content.
 */
@Fluent
public final class AzureBlobContentSource {
    /*
     * Azure Blob Storage container URL.
     */
    @Generated
    @JsonProperty(value = "containerUrl")
    private String containerUrl;

    /*
     * Blob name prefix.
     */
    @Generated
    @JsonProperty(value = "prefix")
    private String prefix;

    /**
     * Creates an instance of AzureBlobContentSource class.
     * 
     * @param containerUrl the containerUrl value to set.
     */
    @Generated
    @JsonCreator
    public AzureBlobContentSource(@JsonProperty(value = "containerUrl") String containerUrl) {
        this.containerUrl = containerUrl;
    }

    /**
     * Get the containerUrl property: Azure Blob Storage container URL.
     * 
     * @return the containerUrl value.
     */
    @Generated
    public String getContainerUrl() {
        return this.containerUrl;
    }

    /**
     * Get the prefix property: Blob name prefix.
     * 
     * @return the prefix value.
     */
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: Blob name prefix.
     * 
     * @param prefix the prefix value to set.
     * @return the AzureBlobContentSource object itself.
     */
    @Generated
    public AzureBlobContentSource setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}
