/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import com.azure.core.util.ContextProvider;
import com.azure.data.model.Permission;
import com.azure.data.model.PermissionMode;
import com.azure.data.model.Resource;
import com.azure.data.model.Timestamp;
import com.azure.data.model.service.DataError;
import com.azure.data.model.service.PermissionProviderError;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.model.service.ResourceType;
import com.azure.data.model.service.Response;
import com.azure.data.service.PermissionCache;
import com.azure.data.service.PermissionProvider;
import com.azure.data.service.PermissionProviderConfiguration;
import com.azure.data.service.PermissionProviderKt$WhenMappings;
import com.azure.data.util.ResourceExtensionsKt;
import com.azure.data.util.ResourceOracle;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a6\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"doGetPermission", "", "Lcom/azure/data/service/PermissionProvider;", "location", "Lcom/azure/data/model/service/ResourceLocation;", "permissionMode", "Lcom/azure/data/model/PermissionMode;", "completion", "Lkotlin/Function1;", "Lcom/azure/data/model/service/Response;", "Lcom/azure/data/model/Permission;", "getPermission", "resourceLocation", "getSelfLink", "", "altLink", "azuredata_release"})
public final class PermissionProviderKt {
    /*
     * WARNING - void declaration
     */
    public static final void getPermission(@NotNull PermissionProvider $this$getPermission, @NotNull ResourceLocation resourceLocation, @NotNull PermissionMode permissionMode, @NotNull Function1<? super Response<Permission>, Unit> completion) {
        boolean bl;
        boolean bl2;
        Object object;
        void location;
        Intrinsics.checkParameterIsNotNull((Object)$this$getPermission, (String)"$this$getPermission");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        if (!PermissionCache.Companion.getShared().isRestored()) {
            PermissionCache.Companion.getShared().restore(ContextProvider.Companion.getAppContext());
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = resourceLocation;
        if ($this$getPermission.getConfiguration() == null) {
            $this$getPermission.setConfiguration(PermissionProviderConfiguration.Companion.getDefault());
        }
        PermissionProviderConfiguration permissionProviderConfiguration = $this$getPermission.getConfiguration();
        if (permissionProviderConfiguration == null) {
            Intrinsics.throwNpe();
        }
        PermissionProviderConfiguration config = permissionProviderConfiguration;
        PermissionProviderConfiguration permissionProviderConfiguration2 = $this$getPermission.getConfiguration();
        if (permissionProviderConfiguration2 == null) {
            Intrinsics.throwNpe();
        }
        PermissionMode mode = permissionProviderConfiguration2.getDefaultPermissionMode() == PermissionMode.All ? PermissionMode.All : permissionMode;
        ResourceType resourceType = ((ResourceLocation)location.element).getResourceType();
        if (!resourceType.getSupportsPermissionToken()) {
            completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
        }
        ResourceType resourceType2 = config.getDefaultResourceType();
        if (resourceType2 != null) {
            object = resourceType2;
            bl2 = false;
            bl = false;
            ResourceType defaultResourceType = object;
            boolean bl3 = false;
            if (resourceType != defaultResourceType && resourceType.isDecendentOf(defaultResourceType)) {
                ResourceLocation resourceLocation2;
                Map<ResourceType, String> ancestorIds = resourceLocation.ancestorIds();
                switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$0[defaultResourceType.ordinal()]) {
                    case 1: {
                        String string = ancestorIds.get((Object)ResourceType.Database);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = ancestorIds.get((Object)ResourceType.Collection);
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        resourceLocation2 = new ResourceLocation.Collection(string, string2);
                        break;
                    }
                    case 2: {
                        String string = ancestorIds.get((Object)ResourceType.Database);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String string3 = ancestorIds.get((Object)ResourceType.Collection);
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        String string4 = ancestorIds.get((Object)ResourceType.Document);
                        if (string4 == null) {
                            Intrinsics.throwNpe();
                        }
                        resourceLocation2 = new ResourceLocation.Document(string, string3, string4);
                        break;
                    }
                    default: {
                        completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidDefaultResourceType()), null, null, null, false, 30, null));
                        return;
                    }
                }
                location.element = resourceLocation2;
            }
        }
        Permission permission = PermissionCache.Companion.getShared().getPermission(((ResourceLocation)location.element).link());
        if (permission != null) {
            object = permission;
            bl2 = false;
            bl = false;
            Object permission2 = object;
            boolean bl4 = false;
            if (((Permission)permission2).getPermissionMode() == PermissionMode.All || ((Permission)permission2).getPermissionMode() == permissionMode) {
                Timestamp timestamp = ((Resource)permission2).getTimestamp();
                if (timestamp != null) {
                    Timestamp timestamp2 = timestamp;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Timestamp timestamp3 = timestamp2;
                    boolean bl7 = false;
                    if (config.getDefaultTokenDuration() - (new Date().getTime() - timestamp3.getTime()) / (long)1000 > config.getTokenRefreshThreshold()) {
                        completion.invoke(new Response<Object>(permission2));
                        return;
                    }
                }
            }
        }
        PermissionProviderKt.doGetPermission($this$getPermission, (ResourceLocation)location.element, mode, (Function1<? super Response<Permission>, Unit>)((Function1)new Function1<Response<Permission>, Unit>((Ref.ObjectRef)location, completion){
            final /* synthetic */ Ref.ObjectRef $location;
            final /* synthetic */ Function1 $completion;

            public final void invoke(@NotNull Response<Permission> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Permission permission = it.getResource();
                if (permission != null) {
                    Permission permission2 = permission;
                    boolean bl = false;
                    boolean bl2 = false;
                    Permission permission3 = permission2;
                    boolean bl3 = false;
                    if (PermissionCache.Companion.getShared().setPermission(permission3, ((ResourceLocation)this.$location.element).link())) {
                        this.$completion.invoke(new Response<Permission>(permission3));
                    } else {
                        this.$completion.invoke(new Response<T>(new DataError(PermissionProviderError.Companion.getPermissionCacheFailed()), null, null, null, false, 30, null));
                    }
                } else {
                    Unit cfr_ignored_0 = (Unit)this.$completion.invoke(new Response<T>(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                }
            }
            {
                this.$location = objectRef;
                this.$completion = function1;
                super(1);
            }
        }));
    }

    private static final void doGetPermission(@NotNull PermissionProvider $this$doGetPermission, ResourceLocation location, PermissionMode permissionMode, Function1<? super Response<Permission>, Unit> completion) {
        Object object;
        ResourceLocation resourceLocation = location;
        if (resourceLocation instanceof ResourceLocation.Collection) {
            String string = location.getId();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String id = string2;
                boolean bl3 = false;
                $this$doGetPermission.getPermissionForCollection(id, ((ResourceLocation.Collection)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
            }
        } else if (resourceLocation instanceof ResourceLocation.StoredProcedure) {
            String string = location.getId();
            if (string != null) {
                String string3 = string;
                boolean bl = false;
                boolean bl4 = false;
                String it = string3;
                boolean bl5 = false;
                $this$doGetPermission.getPermissionForStoredProcedure(it, ((ResourceLocation.StoredProcedure)location).getCollectionId(), ((ResourceLocation.StoredProcedure)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $this$doGetPermission.getPermissionForCollection(((ResourceLocation.StoredProcedure)location).getCollectionId(), ((ResourceLocation.StoredProcedure)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Trigger) {
            String string = location.getId();
            if (string != null) {
                String string4 = string;
                boolean bl = false;
                boolean bl6 = false;
                String it = string4;
                boolean bl7 = false;
                $this$doGetPermission.getPermissionForTrigger(it, ((ResourceLocation.Trigger)location).getCollectionId(), ((ResourceLocation.Trigger)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $this$doGetPermission.getPermissionForCollection(((ResourceLocation.Trigger)location).getCollectionId(), ((ResourceLocation.Trigger)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Udf) {
            String string = location.getId();
            if (string != null) {
                String string5 = string;
                boolean bl = false;
                boolean bl8 = false;
                String it = string5;
                boolean bl9 = false;
                $this$doGetPermission.getPermissionForUserDefinedFunction(it, ((ResourceLocation.Udf)location).getCollectionId(), ((ResourceLocation.Udf)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $this$doGetPermission.getPermissionForCollection(((ResourceLocation.Udf)location).getCollectionId(), ((ResourceLocation.Udf)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Document) {
            String string = location.getId();
            if (string != null) {
                String string6 = string;
                boolean bl = false;
                boolean bl10 = false;
                String it = string6;
                boolean bl11 = false;
                $this$doGetPermission.getPermissionForDocument(it, ((ResourceLocation.Document)location).getCollectionId(), ((ResourceLocation.Document)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $this$doGetPermission.getPermissionForCollection(((ResourceLocation.Document)location).getCollectionId(), ((ResourceLocation.Document)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Attachment) {
            String string = location.getId();
            if (string != null) {
                String string7 = string;
                boolean bl = false;
                boolean bl12 = false;
                String it = string7;
                boolean bl13 = false;
                $this$doGetPermission.getPermissionForAttachment(it, ((ResourceLocation.Attachment)location).getDocumentId(), ((ResourceLocation.Attachment)location).getCollectionId(), ((ResourceLocation.Attachment)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $this$doGetPermission.getPermissionForDocument(((ResourceLocation.Attachment)location).getDocumentId(), ((ResourceLocation.Attachment)location).getCollectionId(), ((ResourceLocation.Attachment)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Resource) {
            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$2[location.getResourceType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
                    break;
                }
                case 5: {
                    String string = (String)ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Resource)location).getResource(), false, 1, null).get((Object)ResourceType.Database);
                    if (string != null) {
                        String string8 = string;
                        boolean bl = false;
                        boolean bl14 = false;
                        String it = string8;
                        boolean bl15 = false;
                        $this$doGetPermission.getPermissionForCollection(((ResourceLocation.Resource)location).getResource().getId(), it, permissionMode, completion);
                        object = Unit.INSTANCE;
                        break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
                default: {
                    Map ancestorIds = ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Resource)location).getResource(), false, 1, null);
                    object = (String)ancestorIds.get((Object)ResourceType.Database);
                    if (object != null) {
                        Unit unit;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl16 = false;
                        Object dbId = object2;
                        boolean bl17 = false;
                        String string = (String)ancestorIds.get((Object)ResourceType.Collection);
                        if (string != null) {
                            String string9 = string;
                            boolean bl18 = false;
                            boolean bl19 = false;
                            String collId = string9;
                            boolean bl20 = false;
                            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$1[location.getResourceType().ordinal()]) {
                                case 1: {
                                    $this$doGetPermission.getPermissionForStoredProcedure(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 2: {
                                    $this$doGetPermission.getPermissionForTrigger(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 3: {
                                    $this$doGetPermission.getPermissionForUserDefinedFunction(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 4: {
                                    $this$doGetPermission.getPermissionForDocument(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 5: {
                                    String string10 = (String)ancestorIds.get((Object)ResourceType.Document);
                                    if (string10 != null) {
                                        String string11 = string10;
                                        boolean bl21 = false;
                                        boolean bl22 = false;
                                        String docId = string11;
                                        boolean bl23 = false;
                                        $this$doGetPermission.getPermissionForAttachment(((ResourceLocation.Resource)location).getResource().getId(), docId, collId, (String)dbId, permissionMode, completion);
                                        unit = Unit.INSTANCE;
                                        break;
                                    }
                                    unit = null;
                                    break;
                                }
                                default: {
                                    unit = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                                }
                            }
                        } else {
                            unit = null;
                        }
                        object = unit;
                        if (unit != null) break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
            }
        } else if (resourceLocation instanceof ResourceLocation.Child) {
            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$4[location.getResourceType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
                    break;
                }
                case 5: {
                    String string = location.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$doGetPermission.getPermissionForCollection(string, ((ResourceLocation.Child)location).getResource().getId(), permissionMode, completion);
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    Map ancestorIds = ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Child)location).getResource(), false, 1, null);
                    String string = (String)ancestorIds.get((Object)ResourceType.Database);
                    if (string != null) {
                        String string12 = string;
                        boolean bl = false;
                        boolean bl24 = false;
                        String dbId = string12;
                        boolean bl25 = false;
                        switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$3[location.getResourceType().ordinal()]) {
                            case 1: {
                                String string13 = location.getId();
                                if (string13 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $this$doGetPermission.getPermissionForStoredProcedure(string13, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 2: {
                                String string14 = location.getId();
                                if (string14 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $this$doGetPermission.getPermissionForTrigger(string14, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 3: {
                                String string15 = location.getId();
                                if (string15 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $this$doGetPermission.getPermissionForUserDefinedFunction(string15, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 4: {
                                String string16 = location.getId();
                                if (string16 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $this$doGetPermission.getPermissionForDocument(string16, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 5: {
                                Unit unit;
                                String string17 = (String)ancestorIds.get((Object)ResourceType.Collection);
                                if (string17 != null) {
                                    Unit unit2;
                                    String string18 = string17;
                                    boolean bl26 = false;
                                    boolean bl27 = false;
                                    String collId = string18;
                                    boolean bl28 = false;
                                    String string19 = location.getId();
                                    if (string19 != null) {
                                        String string20 = string19;
                                        boolean bl29 = false;
                                        boolean bl30 = false;
                                        String it = string20;
                                        boolean bl31 = false;
                                        $this$doGetPermission.getPermissionForAttachment(it, ((ResourceLocation.Child)location).getResource().getId(), collId, dbId, permissionMode, completion);
                                        unit2 = Unit.INSTANCE;
                                    } else {
                                        $this$doGetPermission.getPermissionForDocument(((ResourceLocation.Child)location).getResource().getId(), collId, dbId, permissionMode, completion);
                                        unit2 = Unit.INSTANCE;
                                    }
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                unit = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                                break;
                            }
                            default: {
                                completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                            }
                        }
                        object = Unit.INSTANCE;
                        break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
            }
        } else {
            object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
        }
    }

    @Nullable
    public static final String getSelfLink(@NotNull PermissionProvider $this$getSelfLink, @NotNull String altLink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getSelfLink, (String)"$this$getSelfLink");
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        return ResourceOracle.Companion.getShared().getSelfLink(altLink);
    }
}

