/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.model.spatial;

import com.azure.data.model.spatial.GeoBuilder;
import com.azure.data.model.spatial.LineSegmentObject;
import com.azure.data.model.spatial.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\t\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\t\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/azure/data/model/spatial/GeoStarter;", "TSpatialObj", "Lcom/azure/data/model/spatial/LineSegmentObject;", "TBuilder", "Lcom/azure/data/model/spatial/GeoBuilder;", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "start", "point", "Lcom/azure/data/model/spatial/Point;", "(Lcom/azure/data/model/spatial/Point;)Lcom/azure/data/model/spatial/GeoBuilder;", "y", "", "x", "(DD)Lcom/azure/data/model/spatial/GeoBuilder;", "coord", "", "([D)Lcom/azure/data/model/spatial/GeoBuilder;", "azuredata_release"})
public class GeoStarter<TSpatialObj extends LineSegmentObject, TBuilder extends GeoBuilder<TSpatialObj>> {
    private final Class<TBuilder> clazz;

    @NotNull
    public final TBuilder start(@NotNull double[] coord) {
        Intrinsics.checkParameterIsNotNull((Object)coord, (String)"coord");
        GeoBuilder builder = (GeoBuilder)this.clazz.newInstance();
        builder.addCoordinate(coord);
        GeoBuilder geoBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)geoBuilder, (String)"builder");
        return (TBuilder)geoBuilder;
    }

    @NotNull
    public final TBuilder start(double y, double x) {
        return this.start(new double[]{y, x});
    }

    @NotNull
    public final TBuilder start(@NotNull Point point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return this.start(point.getLongitude(), point.getLatitude());
    }

    public GeoStarter(@NotNull Class<TBuilder> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.clazz = clazz;
    }
}

