/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util.json;

import com.azure.data.model.spatial.Point;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/azure/data/util/json/PointAdapter;", "Lcom/google/gson/JsonSerializer;", "Lcom/azure/data/model/spatial/Point;", "Lcom/google/gson/JsonDeserializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "azuredata_release"})
public final class PointAdapter
implements JsonSerializer<Point>,
JsonDeserializer<Point> {
    @NotNull
    public JsonElement serialize(@Nullable Point src, @Nullable Type typeOfSrc, @NotNull JsonSerializationContext context) {
        JsonElement jsonElement;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Point point = src;
        if (point != null) {
            Point point2 = point;
            boolean bl = false;
            boolean bl2 = false;
            Point it = point2;
            boolean bl3 = false;
            JsonObject json = new JsonObject();
            json.addProperty("type", "Point");
            JsonArray coords = new JsonArray();
            coords.add((Number)it.getLongitude());
            coords.add((Number)it.getLatitude());
            json.add("coordinates", (JsonElement)coords);
            jsonElement = (JsonElement)json;
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        }
        return jsonElement;
    }

    @Nullable
    public Point deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (json.isJsonObject()) {
            JsonObject jObj = json.getAsJsonObject();
            JsonElement jsonElement = jObj.get("type");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"jObj.get(\"type\")");
            String type = jsonElement.getAsString();
            if (Intrinsics.areEqual((Object)type, (Object)"Point")) {
                JsonElement jsonElement2 = jObj.get("coordinates");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"jObj.get(\"coordinates\")");
                JsonArray jArr = jsonElement2.getAsJsonArray();
                if (jArr.size() == 2) {
                    JsonElement jsonElement3 = jArr.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"jArr[0]");
                    double d = jsonElement3.getAsDouble();
                    JsonElement jsonElement4 = jArr.get(1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"jArr[1]");
                    return new Point(d, jsonElement4.getAsDouble());
                }
            }
        }
        return null;
    }
}

