/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util.json;

import com.azure.core.log.LoggerKt;
import com.azure.core.util.DateTypeAdapter;
import com.azure.data.model.Timestamp;
import com.azure.data.model.service.ResourceWriteOperation;
import com.azure.data.model.spatial.LineString;
import com.azure.data.model.spatial.Point;
import com.azure.data.model.spatial.Polygon;
import com.azure.data.util.json.LineSegmentAdapter;
import com.azure.data.util.json.PointAdapter;
import com.azure.data.util.json.ResourceWriteOperationAdapter;
import com.azure.data.util.json.TimestampAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0007\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "setGson", "(Lcom/google/gson/Gson;)V", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "getGsonBuilder", "()Lcom/google/gson/GsonBuilder;", "checkVerboseMode", "azuredata_release"})
public final class GsonConfigKt {
    @NotNull
    private static final GsonBuilder gsonBuilder;
    @NotNull
    public static Gson gson;

    @NotNull
    public static final GsonBuilder getGsonBuilder() {
        return gsonBuilder;
    }

    @NotNull
    public static final Gson getGson() {
        Gson gson = GsonConfigKt.gson;
        if (gson == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gson");
        }
        return gson;
    }

    public static final void setGson(@NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"<set-?>");
        GsonConfigKt.gson = gson;
    }

    @NotNull
    public static final GsonBuilder checkVerboseMode(@NotNull GsonBuilder $this$checkVerboseMode) {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkVerboseMode, (String)"$this$checkVerboseMode");
        if (LoggerKt.getLogLevel() <= 3) {
            $this$checkVerboseMode.setPrettyPrinting();
        }
        return $this$checkVerboseMode;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        Intrinsics.checkExpressionValueIsNotNull((Object)gsonBuilder, (String)"GsonBuilder()\n        .disableHtmlEscaping()");
        GsonBuilder gsonBuilder2 = GsonConfigKt.checkVerboseMode(gsonBuilder).registerTypeAdapter((Type)((Object)Date.class), (Object)new DateTypeAdapter()).registerTypeAdapter((Type)((Object)Timestamp.class), (Object)new TimestampAdapter()).registerTypeAdapter((Type)((Object)Point.class), (Object)new PointAdapter()).registerTypeAdapter((Type)((Object)Polygon.class), (Object)new LineSegmentAdapter()).registerTypeAdapter((Type)((Object)LineString.class), (Object)new LineSegmentAdapter()).registerTypeAdapter((Type)((Object)ResourceWriteOperation.class), (Object)new ResourceWriteOperationAdapter());
        if (gsonBuilder2 == null) {
            Intrinsics.throwNpe();
        }
        GsonConfigKt.gsonBuilder = gsonBuilder2;
    }
}

