/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.azure.core.util.MapCompat;
import com.azure.data.model.Query;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceBase;
import com.azure.data.model.ResourceList;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.util.ResourceFilePath;
import com.azure.data.util.StringExtensionsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u0010\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0013J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0012\u001a\u00020(J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0012\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020,J\u0016\u0010+\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/azure/data/util/ResourceOracle;", "", "appContext", "Landroid/content/Context;", "host", "", "(Landroid/content/Context;Ljava/lang/String;)V", "altLinkLookup", "", "altLinkLookupStorageKey", "altLinkPrefsEditor", "Landroid/content/SharedPreferences$Editor;", "selfLinkLookup", "selfLinkLookupStorageKey", "selfLinkPrefsEditor", "slashCharacter", "", "slashString", "commit", "", "doRemoveLinks", "resource", "Lcom/azure/data/model/Resource;", "resourceLocation", "Lcom/azure/data/model/service/ResourceLocation;", "doStoreLinks", "selfLink", "altLink", "getAltLink", "getDirectoryPath", "query", "Lcom/azure/data/model/Query;", "getFilePath", "Lcom/azure/data/util/ResourceFilePath;", "getParentAltLink", "getParentSelfLink", "getResourceId", "getSelfLink", "purge", "removeLinks", "", "restore", "appCtx", "storeLinks", "Lcom/azure/data/model/ResourceBase;", "Companion", "azuredata_release"})
@SuppressLint(value={"CommitPrefEdits"})
public final class ResourceOracle {
    private final String altLinkLookupStorageKey;
    private final String selfLinkLookupStorageKey;
    private SharedPreferences.Editor altLinkPrefsEditor;
    private SharedPreferences.Editor selfLinkPrefsEditor;
    private Map<String, String> altLinkLookup;
    private Map<String, String> selfLinkLookup;
    private final String slashString = "/";
    private final char slashCharacter = '/';
    @NotNull
    public static ResourceOracle shared;
    public static final Companion Companion;

    public final void restore(@NotNull Context appCtx) {
        String string;
        Map.Entry it;
        Map map;
        Object k;
        Object k2;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        Map $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Intrinsics.checkParameterIsNotNull((Object)appCtx, (String)"appCtx");
        SharedPreferences altLinkPrefs = appCtx.getSharedPreferences(this.altLinkLookupStorageKey, 0);
        SharedPreferences selfLinkPrefs = appCtx.getSharedPreferences(this.selfLinkLookupStorageKey, 0);
        SharedPreferences sharedPreferences = altLinkPrefs;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"altLinkPrefs");
        Map map3 = sharedPreferences.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"altLinkPrefs.all");
        Map map4 = map3;
        ResourceOracle resourceOracle = this;
        boolean $i$f$mapValues = false;
        void var6_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            k2 = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = k2;
            map = map2;
            boolean bl2 = false;
            string = String.valueOf(it.getValue());
            map.put(k, string);
        }
        map = destination$iv$iv;
        resourceOracle.altLinkLookup = MapsKt.toMutableMap((Map)map);
        SharedPreferences sharedPreferences2 = selfLinkPrefs;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences2, (String)"selfLinkPrefs");
        Map map5 = sharedPreferences2.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map5, (String)"selfLinkPrefs.all");
        $this$mapValues$iv = map5;
        resourceOracle = this;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            k2 = it$iv$iv.getKey();
            it = (Map.Entry)element$iv$iv$iv;
            k = k2;
            map = map2;
            boolean bl3 = false;
            string = String.valueOf(it.getValue());
            map.put(k, string);
        }
        map = destination$iv$iv;
        resourceOracle.selfLinkLookup = MapsKt.toMutableMap((Map)map);
        SharedPreferences.Editor editor = altLinkPrefs.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"altLinkPrefs.edit()");
        this.altLinkPrefsEditor = editor;
        SharedPreferences.Editor editor2 = selfLinkPrefs.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"selfLinkPrefs.edit()");
        this.selfLinkPrefsEditor = editor2;
    }

    public final void purge() {
        Map<String, String> map = this.altLinkLookup;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
        }
        map.clear();
        Map<String, String> map2 = this.selfLinkLookup;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
        }
        map2.clear();
        SharedPreferences.Editor editor = this.altLinkPrefsEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkPrefsEditor");
        }
        editor.clear();
        SharedPreferences.Editor editor2 = this.selfLinkPrefsEditor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkPrefsEditor");
        }
        editor2.clear();
        this.commit();
    }

    private final void commit() {
        SharedPreferences.Editor editor = this.altLinkPrefsEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkPrefsEditor");
        }
        editor.apply();
        SharedPreferences.Editor editor2 = this.selfLinkPrefsEditor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkPrefsEditor");
        }
        editor2.apply();
    }

    private final void doStoreLinks(Resource resource) {
        this.doStoreLinks(resource.getSelfLink(), resource.getAltLink());
    }

    private final void doStoreLinks(String selfLink, String altLink) {
        block7: {
            String string = selfLink;
            if (string == null) break block7;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = altLink;
            if (string3 != null) {
                String string4 = string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String it2 = string4;
                boolean bl6 = false;
                List altLinkSubstrings = StringsKt.split$default((CharSequence)altLink, (char[])new char[]{this.slashCharacter}, (boolean)false, (int)0, (int)6, null);
                List selfLinkSubstrings = StringsKt.split$default((CharSequence)StringsKt.trimEnd((String)selfLink, (char[])new char[]{'/'}), (char[])new char[]{this.slashCharacter}, (boolean)false, (int)0, (int)6, null);
                if (selfLinkSubstrings.size() == altLinkSubstrings.size()) {
                    for (int i = 0; i < selfLinkSubstrings.size(); i += 2) {
                        String altLinkComponent = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)altLinkSubstrings, (int)i), (CharSequence)this.slashString, null, null, (int)0, null, null, (int)62, null);
                        String selfLinkComponent = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)selfLinkSubstrings, (int)i), (CharSequence)this.slashString, null, null, (int)0, null, null, (int)62, null) + this.slashCharacter;
                        Map<String, String> map = this.altLinkLookup;
                        if (map == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
                        }
                        map.put(selfLinkComponent, altLinkComponent);
                        Map<String, String> map2 = this.selfLinkLookup;
                        if (map2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
                        }
                        map2.put(altLinkComponent, selfLinkComponent);
                        SharedPreferences.Editor editor = this.altLinkPrefsEditor;
                        if (editor == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkPrefsEditor");
                        }
                        editor.putString(selfLinkComponent, altLinkComponent);
                        SharedPreferences.Editor editor2 = this.selfLinkPrefsEditor;
                        if (editor2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkPrefsEditor");
                        }
                        editor2.putString(altLinkComponent, selfLinkComponent);
                    }
                }
            }
        }
    }

    public final void storeLinks(@NotNull ResourceBase resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        if (resource instanceof ResourceList) {
            for (Resource resourceItem : ((ResourceList)resource).getItems()) {
                this.doStoreLinks(resourceItem);
            }
        } else {
            this.doStoreLinks((Resource)resource);
        }
        this.commit();
    }

    public final void storeLinks(@NotNull String selfLink, @NotNull String altLink) {
        Intrinsics.checkParameterIsNotNull((Object)selfLink, (String)"selfLink");
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        this.doStoreLinks(selfLink, altLink);
    }

    private final void doRemoveLinks(Resource resource) {
        block5: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            String string2 = this.getSelfLink(resource);
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                Map<String, String> map = this.altLinkLookup;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
                }
                map.remove(it);
                SharedPreferences.Editor editor = this.altLinkPrefsEditor;
                if (editor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkPrefsEditor");
                }
                editor.remove(it);
            }
            String string3 = this.getAltLink(resource);
            if (string3 == null) break block5;
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            Map<String, String> map = this.selfLinkLookup;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
            }
            map.remove(it);
            SharedPreferences.Editor editor = this.selfLinkPrefsEditor;
            if (editor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkPrefsEditor");
            }
            editor.remove(it);
        }
    }

    private final void doRemoveLinks(ResourceLocation resourceLocation) {
        block5: {
            String string = this.getSelfLink(resourceLocation);
            if (string == null) break block5;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String selfLink = string2;
            boolean bl3 = false;
            Map<String, String> map = this.altLinkLookup;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
            }
            String string3 = map.remove(selfLink);
            if (string3 != null) {
                String string4 = string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String altLink = string4;
                boolean bl6 = false;
                Map<String, String> map2 = this.selfLinkLookup;
                if (map2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
                }
                map2.remove(altLink);
                SharedPreferences.Editor editor = this.selfLinkPrefsEditor;
                if (editor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkPrefsEditor");
                }
                editor.remove(altLink);
            }
            SharedPreferences.Editor editor = this.altLinkPrefsEditor;
            if (editor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkPrefsEditor");
            }
            editor.remove(selfLink);
        }
    }

    public final void removeLinks(@NotNull Resource resource, boolean commit) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        this.doRemoveLinks(resource);
        if (commit) {
            this.commit();
        }
    }

    public static /* synthetic */ void removeLinks$default(ResourceOracle resourceOracle, Resource resource, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        resourceOracle.removeLinks(resource, bl);
    }

    public final void removeLinks(@NotNull ResourceLocation resourceLocation, boolean commit) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        this.doRemoveLinks(resourceLocation);
        if (commit) {
            this.commit();
        }
    }

    public static /* synthetic */ void removeLinks$default(ResourceOracle resourceOracle, ResourceLocation resourceLocation, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        resourceOracle.removeLinks(resourceLocation, bl);
    }

    @Nullable
    public final String getParentAltLink(@NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        String string = this.getAltLink(resource);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String altLink = string2;
            boolean bl3 = false;
            List altLinkSubstrings = StringsKt.split$default((CharSequence)altLink, (char[])new char[]{this.slashCharacter}, (boolean)false, (int)0, (int)6, null);
            if (altLinkSubstrings.size() > 2) {
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)altLinkSubstrings, (int)2), (CharSequence)this.slashString, null, null, (int)0, null, null, (int)62, null);
            }
        }
        return null;
    }

    @Nullable
    public final String getParentSelfLink(@NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        String string = this.getSelfLink(resource);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String selfLink = string2;
            boolean bl3 = false;
            List selfLinkSubstrings = StringsKt.split$default((CharSequence)StringsKt.trimEnd((String)selfLink, (char[])new char[]{this.slashCharacter}), (char[])new char[]{this.slashCharacter}, (boolean)false, (int)0, (int)6, null);
            if (selfLinkSubstrings.size() > 2) {
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)selfLinkSubstrings, (int)2), (CharSequence)this.slashString, null, null, (int)0, null, null, (int)62, null) + this.slashCharacter;
            }
        }
        return null;
    }

    @Nullable
    public final String getAltLink(@NotNull Resource resource) {
        String altLink;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            String string = resource.getAltLink();
            altLink = string != null ? StringsKt.trim((String)string, (char[])new char[]{this.slashCharacter}) : null;
            CharSequence charSequence = altLink;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) break block2;
            String string2 = resource.getSelfLink();
            if (string2 != null) {
                charSequence = string2;
                bl = false;
                bl2 = false;
                CharSequence it = charSequence;
                boolean bl3 = false;
                Map<String, String> map = this.altLinkLookup;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
                }
                altLink = (String)MapCompat.Companion.getOrDefault(map, (Object)it, null);
            }
        }
        return altLink;
    }

    @Nullable
    public final String getSelfLink(@NotNull Resource resource) {
        String selfLink;
        block1: {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            selfLink = resource.getSelfLink();
            CharSequence charSequence = selfLink;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0) || (string = resource.getAltLink()) == null || (string = StringsKt.trim((String)string, (char[])new char[]{this.slashCharacter})) == null) break block1;
            charSequence = string;
            bl = false;
            bl2 = false;
            CharSequence it = charSequence;
            boolean bl3 = false;
            Map<String, String> map = this.selfLinkLookup;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
            }
            selfLink = (String)MapCompat.Companion.getOrDefault(map, (Object)it, null);
        }
        return selfLink;
    }

    @Nullable
    public final String getSelfLink(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        String altLink = resourceLocation.link();
        Map<String, String> map = this.selfLinkLookup;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
        }
        String string = map.get(altLink);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            if (!(charSequence.length() == 0)) {
                return it;
            }
        }
        return null;
    }

    @Nullable
    public final String getAltLink(@NotNull String selfLink) {
        Intrinsics.checkParameterIsNotNull((Object)selfLink, (String)"selfLink");
        CharSequence charSequence = selfLink;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String altLink;
            Map<String, String> map = this.altLinkLookup;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"altLinkLookup");
            }
            String string = altLink = (String)MapCompat.Companion.getOrDefault(map, (Object)selfLink, null);
            if (string != null) {
                CharSequence charSequence2 = string;
                boolean bl2 = false;
                if (!(charSequence2.length() == 0)) {
                    return altLink;
                }
            }
        }
        return null;
    }

    @Nullable
    public final String getSelfLink(@NotNull String altLink) {
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        String trimmedLink = StringsKt.trim((String)altLink, (char[])new char[]{this.slashCharacter});
        CharSequence charSequence = trimmedLink;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String selfLink;
            Map<String, String> map = this.selfLinkLookup;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selfLinkLookup");
            }
            String string = selfLink = (String)MapCompat.Companion.getOrDefault(map, (Object)trimmedLink, null);
            if (string != null) {
                CharSequence charSequence2 = string;
                boolean bl2 = false;
                if (!(charSequence2.length() == 0)) {
                    return selfLink;
                }
            }
        }
        return null;
    }

    @Nullable
    public final String getResourceId(@NotNull Resource resource, @Nullable String selfLink) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        String resourceId = resource.getResourceId();
        CharSequence charSequence = resourceId;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string = selfLink;
            if (string == null) {
                string = this.getSelfLink(resource);
            }
            if (string != null) {
                String selfLinkSubstring;
                charSequence = string;
                bl = false;
                bl2 = false;
                CharSequence it = charSequence;
                boolean bl3 = false;
                resourceId = selfLinkSubstring = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)StringsKt.trimEnd((String)it, (char[])new char[]{this.slashCharacter}), (char[])new char[]{this.slashCharacter}, (boolean)false, (int)0, (int)6, null));
            }
        }
        String string = resourceId;
        if (string != null) {
            charSequence = string;
            bl = false;
            if (!(charSequence.length() == 0)) {
                return resourceId;
            }
        }
        return null;
    }

    @Nullable
    public static /* synthetic */ String getResourceId$default(ResourceOracle resourceOracle, Resource resource, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return resourceOracle.getResourceId(resource, string);
    }

    @Nullable
    public final ResourceFilePath getFilePath(@NotNull Resource resource) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            String string = this.getSelfLink(resource);
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String selfLink = string2;
            boolean bl3 = false;
            String string3 = this.getResourceId(resource, selfLink);
            if (string3 != null) {
                String string4 = string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String resourceId = string4;
                boolean bl6 = false;
                return new ResourceFilePath(selfLink, resourceId + ".json");
            }
        }
        return null;
    }

    @Nullable
    public final ResourceFilePath getFilePath(@NotNull ResourceLocation resourceLocation) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
            if (resourceLocation.isFeed()) {
                return null;
            }
            String string = this.getSelfLink(resourceLocation);
            if (string == null) break block2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String selfLink = string2;
            boolean bl3 = false;
            String string3 = StringExtensionsKt.extractId(selfLink, resourceLocation.type());
            if (string3 != null) {
                String string4 = string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String resourceId = string4;
                boolean bl6 = false;
                return new ResourceFilePath(selfLink, resourceId + ".json");
            }
        }
        return null;
    }

    @Nullable
    public final String getDirectoryPath(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        String string = this.getSelfLink(resourceLocation);
        if (string == null) {
            return resourceLocation.type();
        }
        String selfLink = string;
        if (resourceLocation.isFeed()) {
            return selfLink + '/' + resourceLocation.type();
        }
        return selfLink;
    }

    @NotNull
    public final String getDirectoryPath(@NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return "queries/" + query.hashCode();
    }

    private ResourceOracle(Context appContext, String host) {
        this.altLinkLookupStorageKey = "com.azure.data.lookup.altlink." + host;
        this.selfLinkLookupStorageKey = "com.azure.data.lookup.selflink." + host;
        this.slashString = "/";
        this.slashCharacter = (char)47;
        this.restore(appContext);
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ ResourceOracle(Context appContext, String host, DefaultConstructorMarker $constructor_marker) {
        this(appContext, host);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/azure/data/util/ResourceOracle$Companion;", "", "()V", "shared", "Lcom/azure/data/util/ResourceOracle;", "getShared", "()Lcom/azure/data/util/ResourceOracle;", "setShared", "(Lcom/azure/data/util/ResourceOracle;)V", "init", "", "appContext", "Landroid/content/Context;", "host", "", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final ResourceOracle getShared() {
            ResourceOracle resourceOracle = shared;
            if (resourceOracle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shared");
            }
            return resourceOracle;
        }

        public final void setShared(@NotNull ResourceOracle resourceOracle) {
            Intrinsics.checkParameterIsNotNull((Object)resourceOracle, (String)"<set-?>");
            shared = resourceOracle;
        }

        public final void init(@NotNull Context appContext, @NotNull String host) {
            Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            this.setShared(new ResourceOracle(appContext, host, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

