/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Context;
import com.azure.data.model.service.ResourceWriteOperation;
import com.azure.data.model.service.ResourceWriteOperationType;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceWriteOperationHierarchicalComparator;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004*\u00020\u0002H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t*\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"pendingWritesDir", "Ljava/io/File;", "Landroid/content/Context;", "pendingWritesFiles", "", "resourceWriteOperationFile", "write", "Lcom/azure/data/model/service/ResourceWriteOperation;", "sortedByResourceType", "", "withType", "type", "Lcom/azure/data/model/service/ResourceWriteOperationType;", "azuredata_release"})
public final class ResourceWriteOperationQueueKt {
    private static final File resourceWriteOperationFile(@NotNull Context $this$resourceWriteOperationFile, ResourceWriteOperation write) {
        return new File(ResourceWriteOperationQueueKt.pendingWritesDir($this$resourceWriteOperationFile), write.getResourceLocalContentPath().hashCode() + ".json");
    }

    private static final List<File> pendingWritesFiles(@NotNull Context $this$pendingWritesFiles) {
        Object[] objectArray = ResourceWriteOperationQueueKt.pendingWritesDir($this$pendingWritesFiles).listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"pendingWritesDir().listFiles()");
        return ArraysKt.asList((Object[])objectArray);
    }

    private static final File pendingWritesDir(@NotNull Context $this$pendingWritesDir) {
        File directory = new File(ResourceCacheKt.azureDataCacheDir($this$pendingWritesDir), "writes");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static final ResourceWriteOperation withType(@NotNull ResourceWriteOperation $this$withType, ResourceWriteOperationType type) {
        return new ResourceWriteOperation(type, $this$withType.getResource(), $this$withType.getResourceLocation(), $this$withType.getResourceLocalContentPath(), $this$withType.getHttpHeaders());
    }

    private static final List<ResourceWriteOperation> sortedByResourceType(@NotNull List<ResourceWriteOperation> $this$sortedByResourceType) {
        return CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedByResourceType, (Comparator)new ResourceWriteOperationHierarchicalComparator()));
    }

    public static final /* synthetic */ List access$sortedByResourceType(List $this$access_u24sortedByResourceType) {
        return ResourceWriteOperationQueueKt.sortedByResourceType($this$access_u24sortedByResourceType);
    }

    public static final /* synthetic */ File access$pendingWritesDir(Context $this$access_u24pendingWritesDir) {
        return ResourceWriteOperationQueueKt.pendingWritesDir($this$access_u24pendingWritesDir);
    }

    public static final /* synthetic */ List access$pendingWritesFiles(Context $this$access_u24pendingWritesFiles) {
        return ResourceWriteOperationQueueKt.pendingWritesFiles($this$access_u24pendingWritesFiles);
    }

    public static final /* synthetic */ ResourceWriteOperation access$withType(ResourceWriteOperation $this$access_u24withType, ResourceWriteOperationType type) {
        return ResourceWriteOperationQueueKt.withType($this$access_u24withType, type);
    }

    public static final /* synthetic */ File access$resourceWriteOperationFile(Context $this$access_u24resourceWriteOperationFile, ResourceWriteOperation write) {
        return ResourceWriteOperationQueueKt.resourceWriteOperationFile($this$access_u24resourceWriteOperationFile, write);
    }
}

