/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data;

import android.content.Context;
import com.azure.core.util.ContextProvider;
import com.azure.data.AzureData;
import com.azure.data.model.Attachment;
import com.azure.data.model.Database;
import com.azure.data.model.Document;
import com.azure.data.model.DocumentCollection;
import com.azure.data.model.Offer;
import com.azure.data.model.Permission;
import com.azure.data.model.PermissionMode;
import com.azure.data.model.Query;
import com.azure.data.model.Resource;
import com.azure.data.model.StoredProcedure;
import com.azure.data.model.Trigger;
import com.azure.data.model.User;
import com.azure.data.model.UserDefinedFunction;
import com.azure.data.model.indexing.IndexingPolicy;
import com.azure.data.model.partition.PartitionKeyRange;
import com.azure.data.model.service.ListResponse;
import com.azure.data.model.service.Response;
import com.azure.data.service.DocumentClient;
import com.azure.data.service.PermissionProvider;
import com.azure.data.service.ResourceCache;
import com.azure.data.service.ResourceEncryptor;
import com.azure.data.util.json.GsonConfigKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/azure/data/AzureData;", "", "()V", "Companion", "azuredata_release"})
public final class AzureData {
    @NotNull
    private static DocumentClient documentClient;
    private static boolean configured;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        documentClient = DocumentClient.Companion.getShared();
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull String accountName, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountName, masterKey, permissionMode, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull String accountName, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountName, masterKey, permissionMode, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountUrl, masterKey, permissionMode, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountUrl, masterKey, permissionMode, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountUrl, masterKey, permissionMode, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountUrl, masterKey, permissionMode, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull String accountName, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountName, permissionProvider, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull String accountName, @NotNull PermissionProvider permissionProvider) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountName, permissionProvider, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountUrl, permissionProvider, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull PermissionProvider permissionProvider) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountUrl, permissionProvider, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
        Companion.configure(context, accountUrl, permissionProvider, configureGsonBuilder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull PermissionProvider permissionProvider) {
        com.azure.data.AzureData$Companion.configure$default(Companion, context, accountUrl, permissionProvider, null, 8, null);
    }

    @JvmStatic
    public static final void reset() {
        Companion.reset();
    }

    public static final boolean isConfigured() {
        return Companion.isConfigured();
    }

    public static final boolean isOfflineDataEnabled() {
        return Companion.isOfflineDataEnabled();
    }

    public static final void setOfflineDataEnabled(boolean value) {
        Companion.setOfflineDataEnabled(value);
    }

    @Nullable
    public static final ResourceEncryptor getResourceEncryptor() {
        return Companion.getResourceEncryptor();
    }

    public static final void setResourceEncryptor(@Nullable ResourceEncryptor value) {
        Companion.setResourceEncryptor(value);
    }

    @JvmStatic
    public static final void createDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<Database>, Unit> callback) {
        Companion.createDatabase(databaseId, callback);
    }

    @JvmStatic
    public static final void createDatabase(@NotNull String databaseId, int throughput, @NotNull Function1<? super Response<Database>, Unit> callback) {
        Companion.createDatabase(databaseId, throughput, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getDatabases(@Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Database>, Unit> callback) {
        Companion.getDatabases(maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getDatabases(@NotNull Function1<? super ListResponse<Database>, Unit> callback) {
        com.azure.data.AzureData$Companion.getDatabases$default(Companion, null, callback, 1, null);
    }

    @JvmStatic
    public static final void getDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<Database>, Unit> callback) {
        Companion.getDatabase(databaseId, callback);
    }

    @JvmStatic
    public static final void deleteDatabase(@NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDatabase(database, callback);
    }

    @JvmStatic
    public static final void deleteDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDatabase(databaseId, callback);
    }

    @JvmStatic
    @Deprecated(message="Creating a collection without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final void createCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, databaseId, callback);
    }

    @JvmStatic
    @Deprecated(message="Creating a collection without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final void createCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, database, callback);
    }

    @JvmStatic
    public static final void createCollection(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, partitionKey, databaseId, callback);
    }

    @JvmStatic
    public static final void createCollection(@NotNull String collectionId, @NotNull String partitionKey, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, partitionKey, database, callback);
    }

    @JvmStatic
    public static final void createCollection(@NotNull String collectionId, int throughput, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, throughput, partitionKey, databaseId, callback);
    }

    @JvmStatic
    public static final void createCollection(@NotNull String collectionId, int throughput, @NotNull String partitionKey, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.createCollection(collectionId, throughput, partitionKey, database, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getCollections(@NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<DocumentCollection>, Unit> callback) {
        Companion.getCollections(databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getCollections(@NotNull String databaseId, @NotNull Function1<? super ListResponse<DocumentCollection>, Unit> callback) {
        com.azure.data.AzureData$Companion.getCollections$default(Companion, databaseId, null, callback, 2, null);
    }

    @JvmStatic
    public static final void getCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.getCollection(collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void getCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.getCollection(collectionId, database, callback);
    }

    @JvmStatic
    public static final void deleteCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteCollection(collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteCollection(collectionId, database, callback);
    }

    @JvmStatic
    public static final void replaceCollection(@NotNull DocumentCollection collection, @NotNull String databaseId, @NotNull IndexingPolicy indexingPolicy, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
        Companion.replaceCollection(collection, databaseId, indexingPolicy, callback);
    }

    @JvmStatic
    public static final void getCollectionPartitionKeyRanges(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<PartitionKeyRange>, Unit> callback) {
        Companion.getCollectionPartitionKeyRanges(collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createDocument(document, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createDocument(document, partitionKey, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createDocument(document, collection, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createDocument(document, partitionKey, collection, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createOrUpdateDocument(document, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createOrUpdateDocument(document, partitionKey, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createOrUpdateDocument(document, collection, callback);
    }

    @JvmStatic
    public static final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.createOrUpdateDocument(document, partitionKey, collection, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void getDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.getDocuments(collectionId, databaseId, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void getDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.getDocuments$default(Companion, collectionId, databaseId, documentClass, null, callback, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void getDocuments(@NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.getDocuments(collection, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void getDocuments(@NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.getDocuments$default(Companion, collection, documentClass, null, callback, 4, null);
    }

    @JvmStatic
    @Deprecated(message="Getting a document without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.getDocument(documentId, collectionId, databaseId, documentClass, callback);
    }

    @JvmStatic
    @Deprecated(message="Getting a document without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final <T extends Document> void getDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.getDocument(documentId, collection, documentClass, callback);
    }

    @JvmStatic
    public static final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.getDocument(documentId, partitionKey, collectionId, databaseId, documentClass, callback);
    }

    @JvmStatic
    public static final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.getDocument(documentId, partitionKey, collection, documentClass, callback);
    }

    @JvmStatic
    @Deprecated(message="Deleting a document without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final void deleteDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDocument(documentId, collectionId, databaseId, callback);
    }

    @JvmStatic
    @Deprecated(message="Deleting a document without a partition key is deprecated and will be removed in a future version of AzureData")
    public static final void deleteDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDocument(documentId, collection, callback);
    }

    @JvmStatic
    public static final void deleteDocument(@NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDocument(document, callback);
    }

    @JvmStatic
    public static final void deleteDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteDocument(documentId, partitionKey, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.replaceDocument(document, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.replaceDocument(document, partitionKey, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final <T extends Document> void replaceDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.replaceDocument(document, collection, callback);
    }

    @JvmStatic
    public static final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.replaceDocument(document, partitionKey, collection, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.queryDocuments(collectionId, databaseId, query, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.queryDocuments$default(Companion, collectionId, databaseId, query, documentClass, null, callback, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.queryDocuments(collectionId, partitionKey, databaseId, query, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.queryDocuments$default(Companion, collectionId, partitionKey, databaseId, query, documentClass, null, callback, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.queryDocuments(collection, query, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.queryDocuments$default(Companion, collection, query, documentClass, null, callback, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull String partitionKey, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.queryDocuments(collection, partitionKey, query, documentClass, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull String partitionKey, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        com.azure.data.AzureData$Companion.queryDocuments$default(Companion, collection, partitionKey, query, documentClass, null, callback, 16, null);
    }

    @JvmStatic
    public static final <T extends Document> void findDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.findDocument(documentId, collectionId, databaseId, documentClass, callback);
    }

    @JvmStatic
    public static final <T extends Document> void findDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
        Companion.findDocument(documentId, collection, documentClass, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, media, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.createAttachment(attachmentId, contentType, media, document, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getAttachments(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
        Companion.getAttachments(documentId, collectionId, databaseId, partitionKey, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getAttachments(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
        com.azure.data.AzureData$Companion.getAttachments$default(Companion, documentId, collectionId, databaseId, partitionKey, null, callback, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getAttachments(@NotNull Document document, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
        Companion.getAttachments(document, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getAttachments(@NotNull Document document, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
        com.azure.data.AzureData$Companion.getAttachments$default(Companion, document, null, callback, 2, null);
    }

    @JvmStatic
    public static final void deleteAttachment(@NotNull Attachment attachment, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteAttachment(attachment, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void deleteAttachment(@NotNull String attachmentId, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteAttachment(attachmentId, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void deleteAttachment(@NotNull Attachment attachment, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteAttachment(attachment, document, callback);
    }

    @JvmStatic
    public static final void deleteAttachment(@NotNull String attachmentId, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteAttachment(attachmentId, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachment(attachmentId, contentType, mediaUrl, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachmentMedia(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.replaceAttachmentMedia(attachmentId, contentType, media, documentId, collectionId, databaseId, partitionKey, callback);
    }

    @JvmStatic
    public static final void replaceAttachmentMedia(@NotNull Attachment attachment, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.replaceAttachmentMedia(attachment, contentType, media, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachmentMedia(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
        Companion.replaceAttachmentMedia(attachmentId, contentType, media, document, callback);
    }

    @JvmStatic
    public static final void replaceAttachmentMedia(@NotNull Attachment attachment, @NotNull String partitionKey, @NotNull String contentType, @NotNull byte[] media, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.replaceAttachmentMedia(attachment, partitionKey, contentType, media, callback);
    }

    @JvmStatic
    public static final void getAttachmentMedia(@NotNull String attachmentId, @NotNull Document document, @NotNull Function1<? super Response<byte[]>, Unit> callback) {
        Companion.getAttachmentMedia(attachmentId, document, callback);
    }

    @JvmStatic
    public static final void getAttachmentMedia(@NotNull Attachment attachment, @NotNull Document document, @NotNull Function1<? super Response<byte[]>, Unit> callback) {
        Companion.getAttachmentMedia(attachment, document, callback);
    }

    @JvmStatic
    public static final void createStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
        Companion.createStoredProcedure(storedProcedureId, procedure, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void createStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
        Companion.createStoredProcedure(storedProcedureId, procedure, collection, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getStoredProcedures(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
        Companion.getStoredProcedures(collectionId, databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getStoredProcedures(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
        com.azure.data.AzureData$Companion.getStoredProcedures$default(Companion, collectionId, databaseId, null, callback, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getStoredProcedures(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
        Companion.getStoredProcedures(collection, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getStoredProcedures(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
        com.azure.data.AzureData$Companion.getStoredProcedures$default(Companion, collection, null, callback, 2, null);
    }

    @JvmStatic
    public static final void deleteStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteStoredProcedure(storedProcedure, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteStoredProcedure(storedProcedure, collection, callback);
    }

    @JvmStatic
    public static final void deleteStoredProcedure(@NotNull String storedProcedureId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteStoredProcedure(storedProcedureId, collection, callback);
    }

    @JvmStatic
    public static final void deleteStoredProcedure(@NotNull String storedProcedureId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteStoredProcedure(storedProcedureId, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void replaceStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
        Companion.replaceStoredProcedure(storedProcedureId, procedure, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void replaceStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
        Companion.replaceStoredProcedure(storedProcedureId, procedure, collection, callback);
    }

    @JvmStatic
    public static final void replaceStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
        Companion.replaceStoredProcedure(storedProcedure, collection, callback);
    }

    @JvmStatic
    public static final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.executeStoredProcedure(storedProcedureId, parameters, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.executeStoredProcedure(storedProcedureId, parameters, partitionKey, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.executeStoredProcedure(storedProcedureId, parameters, collection, callback);
    }

    @JvmStatic
    public static final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.executeStoredProcedure(storedProcedureId, parameters, partitionKey, collection, callback);
    }

    @JvmStatic
    public static final void createUserDefinedFunction(@NotNull String functionId, @NotNull String functionBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
        Companion.createUserDefinedFunction(functionId, functionBody, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void createUserDefinedFunction(@NotNull String functionId, @NotNull String functionBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
        Companion.createUserDefinedFunction(functionId, functionBody, collection, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUserDefinedFunctions(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
        Companion.getUserDefinedFunctions(collectionId, databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUserDefinedFunctions(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
        com.azure.data.AzureData$Companion.getUserDefinedFunctions$default(Companion, collectionId, databaseId, null, callback, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUserDefinedFunctions(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
        Companion.getUserDefinedFunctions(collection, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUserDefinedFunctions(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
        com.azure.data.AzureData$Companion.getUserDefinedFunctions$default(Companion, collection, null, callback, 2, null);
    }

    @JvmStatic
    public static final void deleteUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUserDefinedFunction(userDefinedFunctionId, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUserDefinedFunction(userDefinedFunction, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUserDefinedFunction(userDefinedFunction, collection, callback);
    }

    @JvmStatic
    public static final void deleteUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUserDefinedFunction(userDefinedFunctionId, collection, callback);
    }

    @JvmStatic
    public static final void replaceUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String function, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
        Companion.replaceUserDefinedFunction(userDefinedFunctionId, function, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void replaceUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String function, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
        Companion.replaceUserDefinedFunction(userDefinedFunctionId, function, collection, callback);
    }

    @JvmStatic
    public static final void replaceUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
        Companion.replaceUserDefinedFunction(userDefinedFunction, collection, callback);
    }

    @JvmStatic
    public static final void createTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
        Companion.createTrigger(triggerId, operation, triggerType, triggerBody, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void createTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
        Companion.createTrigger(triggerId, operation, triggerType, triggerBody, collection, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getTriggers(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
        Companion.getTriggers(collectionId, databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getTriggers(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
        com.azure.data.AzureData$Companion.getTriggers$default(Companion, collectionId, databaseId, null, callback, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getTriggers(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
        Companion.getTriggers(collection, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getTriggers(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
        com.azure.data.AzureData$Companion.getTriggers$default(Companion, collection, null, callback, 2, null);
    }

    @JvmStatic
    public static final void deleteTrigger(@NotNull String triggerId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteTrigger(triggerId, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteTrigger(@NotNull Trigger trigger, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteTrigger(trigger, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteTrigger(@NotNull Trigger trigger, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteTrigger(trigger, collection, callback);
    }

    @JvmStatic
    public static final void deleteTrigger(@NotNull String triggerId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteTrigger(triggerId, collection, callback);
    }

    @JvmStatic
    public static final void replaceTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
        Companion.replaceTrigger(triggerId, operation, triggerType, triggerBody, collectionId, databaseId, callback);
    }

    @JvmStatic
    public static final void replaceTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
        Companion.replaceTrigger(triggerId, operation, triggerType, triggerBody, collection, callback);
    }

    @JvmStatic
    public static final void replaceTrigger(@NotNull Trigger trigger, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
        Companion.replaceTrigger(trigger, operation, triggerType, collection, callback);
    }

    @JvmStatic
    public static final void createUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
        Companion.createUser(userId, databaseId, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUsers(@NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<User>, Unit> callback) {
        Companion.getUsers(databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getUsers(@NotNull String databaseId, @NotNull Function1<? super ListResponse<User>, Unit> callback) {
        com.azure.data.AzureData$Companion.getUsers$default(Companion, databaseId, null, callback, 2, null);
    }

    @JvmStatic
    public static final void getUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
        Companion.getUser(userId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUser(userId, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteUser(@NotNull User user, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUser(user, databaseId, callback);
    }

    @JvmStatic
    public static final void deleteUser(@NotNull User user, @NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deleteUser(user, database, callback);
    }

    @JvmStatic
    public static final void replaceUser(@NotNull String userId, @NotNull String newUserId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
        Companion.replaceUser(userId, newUserId, databaseId, callback);
    }

    @JvmStatic
    public static final void replaceUser(@NotNull String userId, @NotNull String newUserId, @NotNull Database database, @NotNull Function1<? super Response<User>, Unit> callback) {
        Companion.replaceUser(userId, newUserId, database, callback);
    }

    @JvmStatic
    public static final void createPermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull Resource resource, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.createPermission(permissionId, permissionMode, resource, userId, databaseId, callback);
    }

    @JvmStatic
    public static final void createPermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull Resource resource, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.createPermission(permissionId, permissionMode, resource, user, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getPermissions(@NotNull String userId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
        Companion.getPermissions(userId, databaseId, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getPermissions(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
        com.azure.data.AzureData$Companion.getPermissions$default(Companion, userId, databaseId, null, callback, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getPermissions(@NotNull User user, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
        Companion.getPermissions(user, maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getPermissions(@NotNull User user, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
        com.azure.data.AzureData$Companion.getPermissions$default(Companion, user, null, callback, 2, null);
    }

    @JvmStatic
    public static final void getPermission(@NotNull String permissionId, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.getPermission(permissionId, userId, databaseId, callback);
    }

    @JvmStatic
    public static final void getPermission(@NotNull String permissionId, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.getPermission(permissionId, user, callback);
    }

    @JvmStatic
    public static final void deletePermission(@NotNull String permissionId, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deletePermission(permissionId, userId, databaseId, callback);
    }

    @JvmStatic
    public static final void deletePermission(@NotNull Permission permission, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deletePermission(permission, userId, databaseId, callback);
    }

    @JvmStatic
    public static final void deletePermission(@NotNull Permission permission, @NotNull User user, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deletePermission(permission, user, callback);
    }

    @JvmStatic
    public static final void deletePermission(@NotNull String permissionId, @NotNull User user, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.deletePermission(permissionId, user, callback);
    }

    @JvmStatic
    public static final void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull String resourceSelfLink, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.replacePermission(permissionId, permissionMode, resourceSelfLink, userId, databaseId, callback);
    }

    @JvmStatic
    public static final <TResource extends Resource> void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull TResource resource, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.replacePermission(permissionId, permissionMode, resource, userId, databaseId, callback);
    }

    @JvmStatic
    public static final void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull String resourceSelfLink, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.replacePermission(permissionId, permissionMode, resourceSelfLink, user, callback);
    }

    @JvmStatic
    public static final <TResource extends Resource> void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull TResource resource, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.replacePermission(permissionId, permissionMode, resource, user, callback);
    }

    @JvmStatic
    public static final void replacePermission(@NotNull Permission permission, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
        Companion.replacePermission(permission, user, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getOffers(@Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Offer>, Unit> callback) {
        Companion.getOffers(maxPerPage, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getOffers(@NotNull Function1<? super ListResponse<Offer>, Unit> callback) {
        com.azure.data.AzureData$Companion.getOffers$default(Companion, null, callback, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Object getOffer(@NotNull String offerId, @NotNull Function1<? super Response<Offer>, Unit> callback) {
        return Companion.getOffer(offerId, callback);
    }

    @JvmStatic
    public static final <T extends Resource> void delete(@NotNull T resource, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.delete(resource, callback);
    }

    @JvmStatic
    public static final <T extends Resource> void refresh(@NotNull T resource, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.refresh(resource, callback);
    }

    @JvmStatic
    public static final <T extends Resource> void delete(@NotNull T resource, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
        Companion.delete(resource, partitionKey, callback);
    }

    @JvmStatic
    public static final <T extends Resource> void refresh(@NotNull T resource, @NotNull String partitionKey, @NotNull Function1<? super Response<T>, Unit> callback) {
        Companion.refresh(resource, partitionKey, callback);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007J>\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007J>\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020*2\u0006\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007J>\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0007JB\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JZ\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u001f2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JZ\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JZ\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020&2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JZ\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020*2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u0010>\u001a\u00020?2\u0006\u00107\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u0010>\u001a\u00020?2\u0006\u00107\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J:\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J:\u0010:\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J*\u0010@\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020<02\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010@\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\u0006\u0010>\u001a\u00020?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020<02\u0012\u0004\u0012\u00020\u001b0#H\u0007JA\u0010A\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010DJI\u0010A\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010EJI\u0010A\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010FJQ\u0010A\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010GJA\u0010H\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010DJI\u0010H\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010EJI\u0010H\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010FJQ\u0010H\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010GJB\u0010I\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007JJ\u0010I\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010K\u001a\u00020L2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007J:\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T02\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T02\u0012\u0004\u0012\u00020\u001b0#H\u0007JJ\u0010U\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\02\u0012\u0004\u0012\u00020\u001b0#H\u0007JR\u0010U\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\02\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010]\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020N02\u0012\u0004\u0012\u00020\u001b0#H\u0007J:\u0010^\u001a\u00020\u001b2\u0006\u0010_\u001a\u00020&2\u0006\u0010`\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a02\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010^\u001a\u00020\u001b2\u0006\u0010_\u001a\u00020&2\u0006\u0010`\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a02\u0012\u0004\u0012\u00020\u001b0#H\u0007J=\u0010b\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u00020L2\u0006\u0010K\u001a\u0002HB2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010dJE\u0010b\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u00020L2\u0006\u0010K\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010eJ6\u0010f\u001a\u00020\u001b2\u0006\u0010g\u001a\u0002032\u0006\u0010/\u001a\u0002002\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JN\u0010f\u001a\u00020\u001b2\u0006\u0010g\u001a\u0002032\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010f\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JN\u0010f\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010h\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010h\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J.\u0010i\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020<2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J.\u0010i\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J.\u0010j\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010j\u001a\u00020\u001b2\u0006\u00104\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J<\u0010j\u001a\u00020\u001b2\u0006\u00104\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#J>\u0010j\u001a\u00020\u001b2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JF\u0010j\u001a\u00020\u001b2\u0006\u00104\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010k\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020O2\u0006\u0010M\u001a\u00020N2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010k\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020O2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010k\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010M\u001a\u00020N2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010k\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010m\u001a\u00020\u001b2\u0006\u0010n\u001a\u00020T2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010m\u001a\u00020\u001b2\u0006\u0010n\u001a\u00020T2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010m\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010m\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\\2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\\2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010o\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010o\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010q\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020N2\u0006\u0010;\u001a\u00020<2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010q\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020N2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010q\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010r\u001a\u00020\u001b2\u0006\u0010s\u001a\u00020a2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010r\u001a\u00020\u001b2\u0006\u0010s\u001a\u00020a2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010r\u001a\u00020\u001b2\u0006\u0010t\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J>\u0010r\u001a\u00020\u001b2\u0006\u0010t\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JF\u0010u\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010w2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JN\u0010u\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010w2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JN\u0010u\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010w2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JV\u0010u\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010w2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JJ\u0010x\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007JR\u0010x\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010|\u001a\u00020\u001b2\u0006\u0010g\u001a\u0002032\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020902\u0012\u0004\u0012\u00020\u001b0#H\u0007J2\u0010|\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020902\u0012\u0004\u0012\u00020\u001b0#H\u0007J;\u0010}\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002030{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010\u007fJT\u0010}\u001a\u00020\u001b2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002030{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0080\u0001J3\u0010\u0081\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J3\u0010\u0081\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007J4\u0010\u0082\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0019\u00101\u001a\u0015\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0083\u00010{\u0012\u0004\u0012\u00020\u001b0#H\u0007J=\u0010\u0084\u0001\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0085\u0001J+\u0010\u0086\u0001\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020<02\u0012\u0004\u0012\u00020\u001b0#H\u0007J5\u0010\u0087\u0001\u001a\u00020\u001b2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0088\u0001JK\u0010\u0089\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007JS\u0010\u0089\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007JS\u0010\u0089\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007J[\u0010\u0089\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00104\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007JU\u0010\u008a\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010C\u001a\u00020=2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u008b\u0001J]\u0010\u008a\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u008c\u0001J-\u0010\u008d\u0001\u001a\u00020\u00012\u0007\u0010\u008e\u0001\u001a\u00020&2\u0019\u00101\u001a\u0015\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u008f\u000102\u0012\u0004\u0012\u00020\u001b0#H\u0007J6\u0010\u0090\u0001\u001a\u00020\u001b2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0019\u00101\u001a\u0015\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u008f\u00010{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0088\u0001J3\u0010\u0091\u0001\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010M\u001a\u00020N2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007J;\u0010\u0091\u0001\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007J=\u0010\u0092\u0001\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020N2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0093\u0001JE\u0010\u0092\u0001\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0094\u0001J=\u0010\u0095\u0001\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020=2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0096\u0001JE\u0010\u0095\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0094\u0001J=\u0010\u0097\u0001\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020=2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0096\u0001JE\u0010\u0097\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0094\u0001J3\u0010\u0098\u0001\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020N02\u0012\u0004\u0012\u00020\u001b0#H\u0007J=\u0010\u0099\u0001\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020=2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0096\u0001JE\u0010\u0099\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0094\u0001J=\u0010\u009a\u0001\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u0085\u0001J_\u0010\u009b\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010C\u001a\u00020=2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u009e\u0001Jg\u0010\u009b\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010C\u001a\u00020=2\u0006\u00107\u001a\u00020&2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u009f\u0001Jg\u0010\u009b\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u00a0\u0001Jo\u0010\u009b\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u00105\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u00106\u001a\u00020&2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\f\u0010y\u001a\b\u0012\u0004\u0012\u0002HB0z2\n\b\u0002\u0010~\u001a\u0004\u0018\u00010?2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0{\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u00a1\u0001J:\u0010\u00a2\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u00020L2\u0006\u0010K\u001a\u0002HB2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010dJB\u0010\u00a2\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u00020L2\u0006\u0010K\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010eJC\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007J[\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u001f2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JC\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007J[\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020&2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JC\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007J[\u0010\u00a3\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020*2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007JG\u0010\u00a4\u0001\u001a\u00020\u001b2\u0006\u0010g\u001a\u0002032\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u0010/\u001a\u0002002\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JG\u0010\u00a4\u0001\u001a\u00020\u001b2\u0006\u0010g\u001a\u0002032\u0006\u00107\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007JC\u0010\u00a4\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020\u001b0#H\u0007J_\u0010\u00a4\u0001\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u001c\u00101\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&02j\u0002`c\u0012\u0004\u0012\u00020\u001b0#H\u0007J=\u0010\u00a5\u0001\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020=2\u0006\u00106\u001a\u00020&2\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=02\u0012\u0004\u0012\u00020\u001b0#H\u0007JB\u0010\u00a8\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010DJJ\u0010\u00a8\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010EJJ\u0010\u00a8\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010FJR\u0010\u00a8\u0001\u001a\u00020\u001b\"\b\b\u0000\u0010B*\u0002002\u0006\u0010/\u001a\u0002HB2\u0006\u00107\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0002\u0010GJ3\u0010\u00a9\u0001\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020O2\u0006\u0010M\u001a\u00020N2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007JU\u0010\u00a9\u0001\u001a\u00020\u001b\"\t\b\u0000\u0010\u00aa\u0001*\u00020L2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0007\u0010K\u001a\u0003H\u00aa\u00012\u0006\u0010M\u001a\u00020N2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u00ab\u0001J]\u0010\u00a9\u0001\u001a\u00020\u001b\"\t\b\u0000\u0010\u00aa\u0001*\u00020L2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0007\u0010K\u001a\u0003H\u00aa\u00012\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007\u00a2\u0006\u0003\u0010\u00ac\u0001JD\u0010\u00a9\u0001\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0007\u0010\u00ad\u0001\u001a\u00020&2\u0006\u0010M\u001a\u00020N2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007JL\u0010\u00a9\u0001\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0007\u0010\u00ad\u0001\u001a\u00020&2\u0006\u0010P\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O02\u0012\u0004\u0012\u00020\u001b0#H\u0007J3\u0010\u00ae\u0001\u001a\u00020\u001b2\u0006\u0010n\u001a\u00020T2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T02\u0012\u0004\u0012\u00020\u001b0#H\u0007J;\u0010\u00ae\u0001\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T02\u0012\u0004\u0012\u00020\u001b0#H\u0007JC\u0010\u00ae\u0001\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020T02\u0012\u0004\u0012\u00020\u001b0#H\u0007JC\u0010\u00af\u0001\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\\2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\02\u0012\u0004\u0012\u00020\u001b0#H\u0007JK\u0010\u00af\u0001\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\02\u0012\u0004\u0012\u00020\u001b0#H\u0007JS\u0010\u00af\u0001\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\02\u0012\u0004\u0012\u00020\u001b0#H\u0007J<\u0010\u00b0\u0001\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0007\u0010\u00b1\u0001\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020N02\u0012\u0004\u0012\u00020\u001b0#H\u0007J<\u0010\u00b0\u0001\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020&2\u0007\u0010\u00b1\u0001\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020N02\u0012\u0004\u0012\u00020\u001b0#H\u0007J3\u0010\u00b2\u0001\u001a\u00020\u001b2\u0006\u0010s\u001a\u00020a2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a02\u0012\u0004\u0012\u00020\u001b0#H\u0007J<\u0010\u00b2\u0001\u001a\u00020\u001b2\u0006\u0010t\u001a\u00020&2\u0007\u0010\u00b3\u0001\u001a\u00020&2\u0006\u0010C\u001a\u00020=2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a02\u0012\u0004\u0012\u00020\u001b0#H\u0007JD\u0010\u00b2\u0001\u001a\u00020\u001b2\u0006\u0010t\u001a\u00020&2\u0007\u0010\u00b3\u0001\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020a02\u0012\u0004\u0012\u00020\u001b0#H\u0007J\t\u0010\u00b4\u0001\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\u000b\u0010\rR*\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0011\u0010\u0012R.\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00138F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u00b5\u0001"}, d2={"Lcom/azure/data/AzureData$Companion;", "", "()V", "configured", "", "documentClient", "Lcom/azure/data/service/DocumentClient;", "getDocumentClient$azuredata_release", "()Lcom/azure/data/service/DocumentClient;", "setDocumentClient$azuredata_release", "(Lcom/azure/data/service/DocumentClient;)V", "isConfigured", "isConfigured$annotations", "()Z", "value", "isOfflineDataEnabled", "isOfflineDataEnabled$annotations", "setOfflineDataEnabled", "(Z)V", "Lcom/azure/data/service/ResourceEncryptor;", "resourceEncryptor", "resourceEncryptor$annotations", "getResourceEncryptor", "()Lcom/azure/data/service/ResourceEncryptor;", "setResourceEncryptor", "(Lcom/azure/data/service/ResourceEncryptor;)V", "configure", "", "context", "Landroid/content/Context;", "accountUrl", "Ljava/net/URL;", "permissionProvider", "Lcom/azure/data/service/PermissionProvider;", "configureGsonBuilder", "Lkotlin/Function1;", "Lcom/google/gson/GsonBuilder;", "masterKey", "", "permissionMode", "Lcom/azure/data/model/PermissionMode;", "accountName", "Lokhttp3/HttpUrl;", "createAttachment", "attachmentId", "contentType", "mediaUrl", "document", "Lcom/azure/data/model/Document;", "callback", "Lcom/azure/data/model/service/Response;", "Lcom/azure/data/model/Attachment;", "documentId", "collectionId", "databaseId", "partitionKey", "media", "", "createCollection", "database", "Lcom/azure/data/model/Database;", "Lcom/azure/data/model/DocumentCollection;", "throughput", "", "createDatabase", "createDocument", "T", "collection", "(Lcom/azure/data/model/Document;Lcom/azure/data/model/DocumentCollection;Lkotlin/jvm/functions/Function1;)V", "(Lcom/azure/data/model/Document;Ljava/lang/String;Lcom/azure/data/model/DocumentCollection;Lkotlin/jvm/functions/Function1;)V", "(Lcom/azure/data/model/Document;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "(Lcom/azure/data/model/Document;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "createOrUpdateDocument", "createPermission", "permissionId", "resource", "Lcom/azure/data/model/Resource;", "user", "Lcom/azure/data/model/User;", "Lcom/azure/data/model/Permission;", "userId", "createStoredProcedure", "storedProcedureId", "procedure", "Lcom/azure/data/model/StoredProcedure;", "createTrigger", "triggerId", "operation", "Lcom/azure/data/model/Trigger$TriggerOperation;", "triggerType", "Lcom/azure/data/model/Trigger$TriggerType;", "triggerBody", "Lcom/azure/data/model/Trigger;", "createUser", "createUserDefinedFunction", "functionId", "functionBody", "Lcom/azure/data/model/UserDefinedFunction;", "delete", "Lcom/azure/data/model/service/DataResponse;", "(Lcom/azure/data/model/Resource;Lkotlin/jvm/functions/Function1;)V", "(Lcom/azure/data/model/Resource;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "deleteAttachment", "attachment", "deleteCollection", "deleteDatabase", "deleteDocument", "deletePermission", "permission", "deleteStoredProcedure", "storedProcedure", "deleteTrigger", "trigger", "deleteUser", "deleteUserDefinedFunction", "userDefinedFunction", "userDefinedFunctionId", "executeStoredProcedure", "parameters", "", "findDocument", "documentClass", "Ljava/lang/Class;", "Lcom/azure/data/model/service/ListResponse;", "getAttachmentMedia", "getAttachments", "maxPerPage", "(Lcom/azure/data/model/Document;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getCollection", "getCollectionPartitionKeyRanges", "Lcom/azure/data/model/partition/PartitionKeyRange;", "getCollections", "(Ljava/lang/String;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getDatabase", "getDatabases", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getDocument", "getDocuments", "(Lcom/azure/data/model/DocumentCollection;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getOffer", "offerId", "Lcom/azure/data/model/Offer;", "getOffers", "getPermission", "getPermissions", "(Lcom/azure/data/model/User;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getStoredProcedures", "(Lcom/azure/data/model/DocumentCollection;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getTriggers", "getUser", "getUserDefinedFunctions", "getUsers", "queryDocuments", "query", "Lcom/azure/data/model/Query;", "(Lcom/azure/data/model/DocumentCollection;Lcom/azure/data/model/Query;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Lcom/azure/data/model/DocumentCollection;Ljava/lang/String;Lcom/azure/data/model/Query;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/String;Lcom/azure/data/model/Query;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/azure/data/model/Query;Ljava/lang/Class;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "refresh", "replaceAttachment", "replaceAttachmentMedia", "replaceCollection", "indexingPolicy", "Lcom/azure/data/model/indexing/IndexingPolicy;", "replaceDocument", "replacePermission", "TResource", "(Ljava/lang/String;Lcom/azure/data/model/PermissionMode;Lcom/azure/data/model/Resource;Lcom/azure/data/model/User;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Lcom/azure/data/model/PermissionMode;Lcom/azure/data/model/Resource;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "resourceSelfLink", "replaceStoredProcedure", "replaceTrigger", "replaceUser", "newUserId", "replaceUserDefinedFunction", "function", "reset", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final DocumentClient getDocumentClient$azuredata_release() {
            return documentClient;
        }

        public final void setDocumentClient$azuredata_release(@NotNull DocumentClient documentClient) {
            Intrinsics.checkParameterIsNotNull((Object)documentClient, (String)"<set-?>");
            AzureData.documentClient = documentClient;
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull String accountName, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountName, masterKey, permissionMode);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, String string, String string2, PermissionMode permissionMode, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = configure.1.INSTANCE;
            }
            companion.configure(context, string, string2, permissionMode, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull String accountName, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountName, masterKey, permissionMode, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountUrl, (String)"accountUrl");
            Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountUrl, masterKey, permissionMode);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, URL uRL, String string, PermissionMode permissionMode, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = configure.2.INSTANCE;
            }
            companion.configure(context, uRL, string, permissionMode, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountUrl, masterKey, permissionMode, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountUrl, (String)"accountUrl");
            Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountUrl, masterKey, permissionMode);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, HttpUrl httpUrl, String string, PermissionMode permissionMode, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = configure.3.INSTANCE;
            }
            companion.configure(context, httpUrl, string, permissionMode, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull String masterKey, @NotNull PermissionMode permissionMode) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountUrl, masterKey, permissionMode, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull String accountName, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)permissionProvider, (String)"permissionProvider");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountName, permissionProvider);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, String string, PermissionProvider permissionProvider, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = configure.4.INSTANCE;
            }
            companion.configure(context, string, permissionProvider, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull String accountName, @NotNull PermissionProvider permissionProvider) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountName, permissionProvider, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountUrl, (String)"accountUrl");
            Intrinsics.checkParameterIsNotNull((Object)permissionProvider, (String)"permissionProvider");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountUrl, permissionProvider);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, URL uRL, PermissionProvider permissionProvider, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = configure.5.INSTANCE;
            }
            companion.configure(context, uRL, permissionProvider, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull URL accountUrl, @NotNull PermissionProvider permissionProvider) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountUrl, permissionProvider, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull PermissionProvider permissionProvider, @NotNull Function1<? super GsonBuilder, GsonBuilder> configureGsonBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)accountUrl, (String)"accountUrl");
            Intrinsics.checkParameterIsNotNull((Object)permissionProvider, (String)"permissionProvider");
            Intrinsics.checkParameterIsNotNull(configureGsonBuilder, (String)"configureGsonBuilder");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            ContextProvider.Companion.init(context2);
            this.getDocumentClient$azuredata_release().configure(accountUrl, permissionProvider);
            configured = true;
            Gson gson = ((GsonBuilder)configureGsonBuilder.invoke((Object)GsonConfigKt.getGsonBuilder())).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"configureGsonBuilder(gsonBuilder).create()");
            GsonConfigKt.setGson(gson);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void configure$default(Companion companion, Context context, HttpUrl httpUrl, PermissionProvider permissionProvider, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = configure.6.INSTANCE;
            }
            companion.configure(context, httpUrl, permissionProvider, (Function1<? super GsonBuilder, GsonBuilder>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void configure(@NotNull Context context, @NotNull HttpUrl accountUrl, @NotNull PermissionProvider permissionProvider) {
            com.azure.data.AzureData$Companion.configure$default(this, context, accountUrl, permissionProvider, null, 8, null);
        }

        @JvmStatic
        public final void reset() {
            this.getDocumentClient$azuredata_release().reset();
            Gson gson = GsonConfigKt.getGsonBuilder().create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"gsonBuilder.create()");
            GsonConfigKt.setGson(gson);
            configured = false;
        }

        @JvmStatic
        public static /* synthetic */ void isConfigured$annotations() {
        }

        public final boolean isConfigured() {
            return configured && Companion.getDocumentClient$azuredata_release().isConfigured();
        }

        @JvmStatic
        public static /* synthetic */ void isOfflineDataEnabled$annotations() {
        }

        public final boolean isOfflineDataEnabled() {
            return ResourceCache.Companion.getShared().isEnabled();
        }

        public final void setOfflineDataEnabled(boolean value) {
            ((Function0)new Function0<Unit>(value){
                final /* synthetic */ boolean $value;

                public final void invoke() {
                    ResourceCache.Companion.getShared().setEnabled(this.$value);
                }
                {
                    this.$value = bl;
                    super(0);
                }
            }).invoke();
        }

        @JvmStatic
        public static /* synthetic */ void resourceEncryptor$annotations() {
        }

        @Nullable
        public final ResourceEncryptor getResourceEncryptor() {
            return ResourceCache.Companion.getShared().getResourceEncryptor();
        }

        public final void setResourceEncryptor(@Nullable ResourceEncryptor value) {
            ((Function0)new Function0<Unit>(value){
                final /* synthetic */ ResourceEncryptor $value;

                public final void invoke() {
                    ResourceCache.Companion.getShared().setResourceEncryptor(this.$value);
                }
                {
                    this.$value = resourceEncryptor2;
                    super(0);
                }
            }).invoke();
        }

        @JvmStatic
        public final void createDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<Database>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDatabase(databaseId, null, callback);
        }

        @JvmStatic
        public final void createDatabase(@NotNull String databaseId, int throughput, @NotNull Function1<? super Response<Database>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDatabase(databaseId, throughput, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getDatabases(@Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Database>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDatabases(maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getDatabases$default(Companion companion, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            companion.getDatabases(n, (Function1<? super ListResponse<Database>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getDatabases(@NotNull Function1<? super ListResponse<Database>, Unit> callback) {
            com.azure.data.AzureData$Companion.getDatabases$default(this, null, callback, 1, null);
        }

        @JvmStatic
        public final void getDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<Database>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDatabase(databaseId, callback);
        }

        @JvmStatic
        public final void deleteDatabase(@NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDatabase(database.getId(), callback);
        }

        @JvmStatic
        public final void deleteDatabase(@NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDatabase(databaseId, callback);
        }

        @JvmStatic
        @Deprecated(message="Creating a collection without a partition key is deprecated and will be removed in a future version of AzureData")
        public final void createCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, databaseId, callback);
        }

        @JvmStatic
        @Deprecated(message="Creating a collection without a partition key is deprecated and will be removed in a future version of AzureData")
        public final void createCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, database.getId(), callback);
        }

        @JvmStatic
        public final void createCollection(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, null, partitionKey, databaseId, callback);
        }

        @JvmStatic
        public final void createCollection(@NotNull String collectionId, @NotNull String partitionKey, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, null, partitionKey, database.getId(), callback);
        }

        @JvmStatic
        public final void createCollection(@NotNull String collectionId, int throughput, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, throughput, partitionKey, databaseId, callback);
        }

        @JvmStatic
        public final void createCollection(@NotNull String collectionId, int throughput, @NotNull String partitionKey, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createCollection(collectionId, throughput, partitionKey, database.getId(), callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getCollections(@NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getCollectionsIn(databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getCollections$default(Companion companion, String string, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getCollections(string, n, (Function1<? super ListResponse<DocumentCollection>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getCollections(@NotNull String databaseId, @NotNull Function1<? super ListResponse<DocumentCollection>, Unit> callback) {
            com.azure.data.AzureData$Companion.getCollections$default(this, databaseId, null, callback, 2, null);
        }

        @JvmStatic
        public final void getCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getCollection(collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void getCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getCollection(collectionId, database.getId(), callback);
        }

        @JvmStatic
        public final void deleteCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteCollection(collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteCollection(@NotNull String collectionId, @NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteCollection(collectionId, database.getId(), callback);
        }

        @JvmStatic
        public final void replaceCollection(@NotNull DocumentCollection collection, @NotNull String databaseId, @NotNull IndexingPolicy indexingPolicy, @NotNull Function1<? super Response<DocumentCollection>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)indexingPolicy, (String)"indexingPolicy");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceCollection(collection, databaseId, indexingPolicy, callback);
        }

        @JvmStatic
        public final void getCollectionPartitionKeyRanges(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<PartitionKeyRange>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getCollectionPartitionKeyRanges(collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void createDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDocument(document, null, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void createDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDocument(document, partitionKey, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void createDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDocument(document, null, collection, callback);
        }

        @JvmStatic
        public final <T extends Document> void createDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createDocument(document, partitionKey, collection, callback);
        }

        @JvmStatic
        public final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createOrUpdateDocument(document, null, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createOrUpdateDocument(document, partitionKey, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createOrUpdateDocument(document, null, collection, callback);
        }

        @JvmStatic
        public final <T extends Document> void createOrUpdateDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createOrUpdateDocument(document, partitionKey, collection, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void getDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocumentsAs(collectionId, databaseId, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getDocuments$default(Companion companion, String string, String string2, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = null;
            }
            companion.getDocuments(string, string2, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void getDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.getDocuments$default(this, collectionId, databaseId, documentClass, null, callback, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void getDocuments(@NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocumentsAs(collection, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getDocuments$default(Companion companion, DocumentCollection documentCollection, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            companion.getDocuments(documentCollection, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void getDocuments(@NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.getDocuments$default(this, collection, documentClass, null, callback, 4, null);
        }

        @JvmStatic
        @Deprecated(message="Getting a document without a partition key is deprecated and will be removed in a future version of AzureData")
        public final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocument(documentId, null, collectionId, databaseId, documentClass, callback);
        }

        @JvmStatic
        @Deprecated(message="Getting a document without a partition key is deprecated and will be removed in a future version of AzureData")
        public final <T extends Document> void getDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocument(documentId, null, collection, documentClass, callback);
        }

        @JvmStatic
        public final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocument(documentId, partitionKey, collectionId, databaseId, documentClass, callback);
        }

        @JvmStatic
        public final <T extends Document> void getDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getDocument(documentId, partitionKey, collection, documentClass, callback);
        }

        @JvmStatic
        @Deprecated(message="Deleting a document without a partition key is deprecated and will be removed in a future version of AzureData")
        public final void deleteDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDocument(documentId, collectionId, databaseId, callback);
        }

        @JvmStatic
        @Deprecated(message="Deleting a document without a partition key is deprecated and will be removed in a future version of AzureData")
        public final void deleteDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDocument(documentId, collection, callback);
        }

        @JvmStatic
        public final void deleteDocument(@NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().delete((Resource)document, null, callback);
        }

        @JvmStatic
        public final void deleteDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDocument(documentId, partitionKey, collectionId, databaseId, callback);
        }

        public final void deleteDocument(@NotNull String documentId, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteDocument(documentId, partitionKey, collection, callback);
        }

        @JvmStatic
        public final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceDocument(document, null, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceDocument(document, partitionKey, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final <T extends Document> void replaceDocument(@NotNull T document, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceDocument(document, null, collection, callback);
        }

        @JvmStatic
        public final <T extends Document> void replaceDocument(@NotNull T document, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceDocument(document, partitionKey, collection, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().queryDocuments(collectionId, databaseId, query, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void queryDocuments$default(Companion companion, String string, String string2, Query query, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            companion.queryDocuments(string, string2, query, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.queryDocuments$default(this, collectionId, databaseId, query, documentClass, null, callback, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().queryDocuments(collectionId, partitionKey, databaseId, query, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void queryDocuments$default(Companion companion, String string, String string2, String string3, Query query, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                n = null;
            }
            companion.queryDocuments(string, string2, string3, query, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull String collectionId, @NotNull String partitionKey, @NotNull String databaseId, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.queryDocuments$default(this, collectionId, partitionKey, databaseId, query, documentClass, null, callback, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().queryDocuments(collection, query, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void queryDocuments$default(Companion companion, DocumentCollection documentCollection, Query query, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = null;
            }
            companion.queryDocuments(documentCollection, query, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.queryDocuments$default(this, collection, query, documentClass, null, callback, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull String partitionKey, @NotNull Query query, @NotNull Class<T> documentClass, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().queryDocuments(collection, partitionKey, query, documentClass, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void queryDocuments$default(Companion companion, DocumentCollection documentCollection, String string, Query query, Class clazz, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            companion.queryDocuments(documentCollection, string, query, clazz, n, function1);
        }

        @JvmStatic
        @JvmOverloads
        public final <T extends Document> void queryDocuments(@NotNull DocumentCollection collection, @NotNull String partitionKey, @NotNull Query query, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            com.azure.data.AzureData$Companion.queryDocuments$default(this, collection, partitionKey, query, documentClass, null, callback, 16, null);
        }

        @JvmStatic
        public final <T extends Document> void findDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().findDocument(documentId, collectionId, databaseId, documentClass, callback);
        }

        @JvmStatic
        public final <T extends Document> void findDocument(@NotNull String documentId, @NotNull DocumentCollection collection, @NotNull Class<T> documentClass, @NotNull Function1<? super ListResponse<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(documentClass, (String)"documentClass");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().findDocument(documentId, collection, documentClass, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.parse((String)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(mediaUrl)!!");
            documentClient.createAttachment(attachmentId, contentType, httpUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.get((URL)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.get(mediaUrl)!!");
            documentClient.createAttachment(attachmentId, contentType, httpUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createAttachment(attachmentId, contentType, media, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createAttachment(attachmentId, contentType, mediaUrl, document, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.parse((String)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(mediaUrl)!!");
            documentClient.createAttachment(attachmentId, contentType, httpUrl, document, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.get((URL)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.get(mediaUrl)!!");
            documentClient.createAttachment(attachmentId, contentType, httpUrl, document, callback);
        }

        @JvmStatic
        public final void createAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createAttachment(attachmentId, contentType, media, document, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getAttachments(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getAttachments(documentId, collectionId, databaseId, partitionKey, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getAttachments$default(Companion companion, String string, String string2, String string3, String string4, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            companion.getAttachments(string, string2, string3, string4, n, (Function1<? super ListResponse<Attachment>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getAttachments(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
            com.azure.data.AzureData$Companion.getAttachments$default(this, documentId, collectionId, databaseId, partitionKey, null, callback, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getAttachments(@NotNull Document document, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getAttachments(document, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getAttachments$default(Companion companion, Document document, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getAttachments(document, n, (Function1<? super ListResponse<Attachment>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getAttachments(@NotNull Document document, @NotNull Function1<? super ListResponse<Attachment>, Unit> callback) {
            com.azure.data.AzureData$Companion.getAttachments$default(this, document, null, callback, 2, null);
        }

        @JvmStatic
        public final void deleteAttachment(@NotNull Attachment attachment, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteAttachment(attachment.getId(), documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void deleteAttachment(@NotNull String attachmentId, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteAttachment(attachmentId, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void deleteAttachment(@NotNull Attachment attachment, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteAttachment(attachment.getId(), document, callback);
        }

        @JvmStatic
        public final void deleteAttachment(@NotNull String attachmentId, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteAttachment(attachmentId, document, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachment(attachmentId, contentType, mediaUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.parse((String)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(mediaUrl)!!");
            documentClient.replaceAttachment(attachmentId, contentType, httpUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.get((URL)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.get(mediaUrl)!!");
            documentClient.replaceAttachment(attachmentId, contentType, httpUrl, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull HttpUrl mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachment(attachmentId, contentType, mediaUrl, document, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull String mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.parse((String)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(mediaUrl)!!");
            documentClient.replaceAttachment(attachmentId, contentType, httpUrl, document, callback);
        }

        @JvmStatic
        public final void replaceAttachment(@NotNull String attachmentId, @NotNull String contentType, @NotNull URL mediaUrl, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            HttpUrl httpUrl = HttpUrl.get((URL)mediaUrl);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.get(mediaUrl)!!");
            documentClient.replaceAttachment(attachmentId, contentType, httpUrl, document, callback);
        }

        @JvmStatic
        public final void replaceAttachmentMedia(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachmentMedia(attachmentId, contentType, media, documentId, collectionId, databaseId, partitionKey, callback);
        }

        @JvmStatic
        public final void replaceAttachmentMedia(@NotNull Attachment attachment, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachmentMedia(attachment, contentType, media, document, callback);
        }

        @JvmStatic
        public final void replaceAttachmentMedia(@NotNull String attachmentId, @NotNull String contentType, @NotNull byte[] media, @NotNull Document document, @NotNull Function1<? super Response<Attachment>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachmentMedia(attachmentId, contentType, media, document, callback);
        }

        @JvmStatic
        public final void replaceAttachmentMedia(@NotNull Attachment attachment, @NotNull String partitionKey, @NotNull String contentType, @NotNull byte[] media, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
            Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceAttachmentMedia(attachment, partitionKey, contentType, media, callback);
        }

        @JvmStatic
        public final void getAttachmentMedia(@NotNull String attachmentId, @NotNull Document document, @NotNull Function1<? super Response<byte[]>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getAttachmentMedia(attachmentId, document, callback);
        }

        @JvmStatic
        public final void getAttachmentMedia(@NotNull Attachment attachment, @NotNull Document document, @NotNull Function1<? super Response<byte[]>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getAttachmentMedia(attachment, document, callback);
        }

        @JvmStatic
        public final void createStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createStoredProcedure(storedProcedureId, procedure, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void createStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createStoredProcedure(storedProcedureId, procedure, collection, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getStoredProcedures(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getStoredProcedures(collectionId, databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getStoredProcedures$default(Companion companion, String string, String string2, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            companion.getStoredProcedures(string, string2, n, (Function1<? super ListResponse<StoredProcedure>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getStoredProcedures(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
            com.azure.data.AzureData$Companion.getStoredProcedures$default(this, collectionId, databaseId, null, callback, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getStoredProcedures(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getStoredProcedures(collection, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getStoredProcedures$default(Companion companion, DocumentCollection documentCollection, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getStoredProcedures(documentCollection, n, (Function1<? super ListResponse<StoredProcedure>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getStoredProcedures(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<StoredProcedure>, Unit> callback) {
            com.azure.data.AzureData$Companion.getStoredProcedures$default(this, collection, null, callback, 2, null);
        }

        @JvmStatic
        public final void deleteStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedure, (String)"storedProcedure");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteStoredProcedure(storedProcedure.getId(), collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedure, (String)"storedProcedure");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteStoredProcedure(storedProcedure.getId(), collection, callback);
        }

        @JvmStatic
        public final void deleteStoredProcedure(@NotNull String storedProcedureId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteStoredProcedure(storedProcedureId, collection, callback);
        }

        @JvmStatic
        public final void deleteStoredProcedure(@NotNull String storedProcedureId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteStoredProcedure(storedProcedureId, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void replaceStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceStoredProcedure(storedProcedureId, procedure, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void replaceStoredProcedure(@NotNull String storedProcedureId, @NotNull String procedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceStoredProcedure(storedProcedureId, procedure, collection, callback);
        }

        @JvmStatic
        public final void replaceStoredProcedure(@NotNull StoredProcedure storedProcedure, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<StoredProcedure>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedure, (String)"storedProcedure");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = storedProcedure.getId();
            String string2 = storedProcedure.getBody();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replaceStoredProcedure(string, string2, collection, callback);
        }

        @JvmStatic
        public final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().executeStoredProcedure(storedProcedureId, parameters, null, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String partitionKey, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().executeStoredProcedure(storedProcedureId, parameters, partitionKey, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().executeStoredProcedure(storedProcedureId, parameters, null, collection, callback);
        }

        @JvmStatic
        public final void executeStoredProcedure(@NotNull String storedProcedureId, @Nullable List<String> parameters, @NotNull String partitionKey, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().executeStoredProcedure(storedProcedureId, parameters, partitionKey, collection, callback);
        }

        @JvmStatic
        public final void createUserDefinedFunction(@NotNull String functionId, @NotNull String functionBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)functionId, (String)"functionId");
            Intrinsics.checkParameterIsNotNull((Object)functionBody, (String)"functionBody");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createUserDefinedFunction(functionId, functionBody, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void createUserDefinedFunction(@NotNull String functionId, @NotNull String functionBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)functionId, (String)"functionId");
            Intrinsics.checkParameterIsNotNull((Object)functionBody, (String)"functionBody");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createUserDefinedFunction(functionId, functionBody, collection, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUserDefinedFunctions(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getUserDefinedFunctions(collectionId, databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getUserDefinedFunctions$default(Companion companion, String string, String string2, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            companion.getUserDefinedFunctions(string, string2, n, (Function1<? super ListResponse<UserDefinedFunction>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUserDefinedFunctions(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
            com.azure.data.AzureData$Companion.getUserDefinedFunctions$default(this, collectionId, databaseId, null, callback, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUserDefinedFunctions(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getUserDefinedFunctions(collection, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getUserDefinedFunctions$default(Companion companion, DocumentCollection documentCollection, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getUserDefinedFunctions(documentCollection, n, (Function1<? super ListResponse<UserDefinedFunction>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUserDefinedFunctions(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<UserDefinedFunction>, Unit> callback) {
            com.azure.data.AzureData$Companion.getUserDefinedFunctions$default(this, collection, null, callback, 2, null);
        }

        @JvmStatic
        public final void deleteUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunctionId, (String)"userDefinedFunctionId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUserDefinedFunction(userDefinedFunctionId, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunction, (String)"userDefinedFunction");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUserDefinedFunction(userDefinedFunction.getId(), collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunction, (String)"userDefinedFunction");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUserDefinedFunction(userDefinedFunction.getId(), collection, callback);
        }

        @JvmStatic
        public final void deleteUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunctionId, (String)"userDefinedFunctionId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUserDefinedFunction(userDefinedFunctionId, collection, callback);
        }

        @JvmStatic
        public final void replaceUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String function, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunctionId, (String)"userDefinedFunctionId");
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceUserDefinedFunction(userDefinedFunctionId, function, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void replaceUserDefinedFunction(@NotNull String userDefinedFunctionId, @NotNull String function, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunctionId, (String)"userDefinedFunctionId");
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceUserDefinedFunction(userDefinedFunctionId, function, collection, callback);
        }

        @JvmStatic
        public final void replaceUserDefinedFunction(@NotNull UserDefinedFunction userDefinedFunction, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<UserDefinedFunction>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userDefinedFunction, (String)"userDefinedFunction");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = userDefinedFunction.getId();
            String string2 = userDefinedFunction.getBody();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replaceUserDefinedFunction(string, string2, collection, callback);
        }

        @JvmStatic
        public final void createTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull((Object)((Object)triggerType), (String)"triggerType");
            Intrinsics.checkParameterIsNotNull((Object)triggerBody, (String)"triggerBody");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createTrigger(triggerId, operation, triggerType, triggerBody, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void createTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull((Object)((Object)triggerType), (String)"triggerType");
            Intrinsics.checkParameterIsNotNull((Object)triggerBody, (String)"triggerBody");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createTrigger(triggerId, operation, triggerType, triggerBody, collection, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getTriggers(@NotNull String collectionId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getTriggers(collectionId, databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getTriggers$default(Companion companion, String string, String string2, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            companion.getTriggers(string, string2, n, (Function1<? super ListResponse<Trigger>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getTriggers(@NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
            com.azure.data.AzureData$Companion.getTriggers$default(this, collectionId, databaseId, null, callback, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getTriggers(@NotNull DocumentCollection collection, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getTriggers(collection, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getTriggers$default(Companion companion, DocumentCollection documentCollection, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getTriggers(documentCollection, n, (Function1<? super ListResponse<Trigger>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getTriggers(@NotNull DocumentCollection collection, @NotNull Function1<? super ListResponse<Trigger>, Unit> callback) {
            com.azure.data.AzureData$Companion.getTriggers$default(this, collection, null, callback, 2, null);
        }

        @JvmStatic
        public final void deleteTrigger(@NotNull String triggerId, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteTrigger(triggerId, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteTrigger(@NotNull Trigger trigger, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteTrigger(trigger.getId(), collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteTrigger(@NotNull Trigger trigger, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteTrigger(trigger.getId(), collection, callback);
        }

        @JvmStatic
        public final void deleteTrigger(@NotNull String triggerId, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteTrigger(triggerId, collection, callback);
        }

        @JvmStatic
        public final void replaceTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull String collectionId, @NotNull String databaseId, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull((Object)((Object)triggerType), (String)"triggerType");
            Intrinsics.checkParameterIsNotNull((Object)triggerBody, (String)"triggerBody");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceTrigger(triggerId, operation, triggerType, triggerBody, collectionId, databaseId, callback);
        }

        @JvmStatic
        public final void replaceTrigger(@NotNull String triggerId, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull String triggerBody, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull((Object)((Object)triggerType), (String)"triggerType");
            Intrinsics.checkParameterIsNotNull((Object)triggerBody, (String)"triggerBody");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceTrigger(triggerId, operation, triggerType, triggerBody, collection, callback);
        }

        @JvmStatic
        public final void replaceTrigger(@NotNull Trigger trigger, @NotNull Trigger.TriggerOperation operation, @NotNull Trigger.TriggerType triggerType, @NotNull DocumentCollection collection, @NotNull Function1<? super Response<Trigger>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull((Object)((Object)triggerType), (String)"triggerType");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = trigger.getId();
            String string2 = trigger.getBody();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replaceTrigger(string, operation, triggerType, string2, collection, callback);
        }

        @JvmStatic
        public final void createUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createUser(userId, databaseId, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUsers(@NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<User>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getUsers(databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getUsers$default(Companion companion, String string, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getUsers(string, n, (Function1<? super ListResponse<User>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getUsers(@NotNull String databaseId, @NotNull Function1<? super ListResponse<User>, Unit> callback) {
            com.azure.data.AzureData$Companion.getUsers$default(this, databaseId, null, callback, 2, null);
        }

        @JvmStatic
        public final void getUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getUser(userId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteUser(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUser(userId, databaseId, callback);
        }

        @JvmStatic
        public final void deleteUser(@NotNull User user, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUser(user.getId(), databaseId, callback);
        }

        @JvmStatic
        public final void deleteUser(@NotNull User user, @NotNull Database database, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deleteUser(user.getId(), database.getId(), callback);
        }

        @JvmStatic
        public final void replaceUser(@NotNull String userId, @NotNull String newUserId, @NotNull String databaseId, @NotNull Function1<? super Response<User>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)newUserId, (String)"newUserId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceUser(userId, newUserId, databaseId, callback);
        }

        @JvmStatic
        public final void replaceUser(@NotNull String userId, @NotNull String newUserId, @NotNull Database database, @NotNull Function1<? super Response<User>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)newUserId, (String)"newUserId");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replaceUser(userId, newUserId, database.getId(), callback);
        }

        @JvmStatic
        public final void createPermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull Resource resource, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createPermission(permissionId, permissionMode, resource, userId, databaseId, callback);
        }

        @JvmStatic
        public final void createPermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull Resource resource, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().createPermission(permissionId, permissionMode, resource, user, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getPermissions(@NotNull String userId, @NotNull String databaseId, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getPermissions(userId, databaseId, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getPermissions$default(Companion companion, String string, String string2, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            companion.getPermissions(string, string2, n, (Function1<? super ListResponse<Permission>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getPermissions(@NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
            com.azure.data.AzureData$Companion.getPermissions$default(this, userId, databaseId, null, callback, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getPermissions(@NotNull User user, @Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getPermissions(user, maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getPermissions$default(Companion companion, User user, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            companion.getPermissions(user, n, (Function1<? super ListResponse<Permission>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getPermissions(@NotNull User user, @NotNull Function1<? super ListResponse<Permission>, Unit> callback) {
            com.azure.data.AzureData$Companion.getPermissions$default(this, user, null, callback, 2, null);
        }

        @JvmStatic
        public final void getPermission(@NotNull String permissionId, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getPermission(permissionId, userId, databaseId, callback);
        }

        @JvmStatic
        public final void getPermission(@NotNull String permissionId, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getPermission(permissionId, user, callback);
        }

        @JvmStatic
        public final void deletePermission(@NotNull String permissionId, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deletePermission(permissionId, userId, databaseId, callback);
        }

        @JvmStatic
        public final void deletePermission(@NotNull Permission permission, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deletePermission(permission.getId(), userId, databaseId, callback);
        }

        @JvmStatic
        public final void deletePermission(@NotNull Permission permission, @NotNull User user, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deletePermission(permission.getId(), user, callback);
        }

        @JvmStatic
        public final void deletePermission(@NotNull String permissionId, @NotNull User user, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().deletePermission(permissionId, user, callback);
        }

        @JvmStatic
        public final void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull String resourceSelfLink, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull((Object)resourceSelfLink, (String)"resourceSelfLink");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replacePermission(permissionId, permissionMode, resourceSelfLink, userId, databaseId, callback);
        }

        @JvmStatic
        public final <TResource extends Resource> void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull TResource resource, @NotNull String userId, @NotNull String databaseId, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = resource.getSelfLink();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replacePermission(permissionId, permissionMode, string, userId, databaseId, callback);
        }

        @JvmStatic
        public final void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull String resourceSelfLink, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull((Object)resourceSelfLink, (String)"resourceSelfLink");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().replacePermission(permissionId, permissionMode, resourceSelfLink, user, callback);
        }

        @JvmStatic
        public final <TResource extends Resource> void replacePermission(@NotNull String permissionId, @NotNull PermissionMode permissionMode, @NotNull TResource resource, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = resource.getSelfLink();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replacePermission(permissionId, permissionMode, string, user, callback);
        }

        @JvmStatic
        public final void replacePermission(@NotNull Permission permission, @NotNull User user, @NotNull Function1<? super Response<Permission>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            DocumentClient documentClient = this.getDocumentClient$azuredata_release();
            String string = permission.getId();
            PermissionMode permissionMode = permission.getPermissionMode();
            if (permissionMode == null) {
                Intrinsics.throwNpe();
            }
            String string2 = permission.getResourceLink();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            documentClient.replacePermission(string, permissionMode, string2, user, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getOffers(@Nullable Integer maxPerPage, @NotNull Function1<? super ListResponse<Offer>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().getOffers(maxPerPage, callback);
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ void getOffers$default(Companion companion, Integer n, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            companion.getOffers(n, (Function1<? super ListResponse<Offer>, Unit>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final void getOffers(@NotNull Function1<? super ListResponse<Offer>, Unit> callback) {
            com.azure.data.AzureData$Companion.getOffers$default(this, null, callback, 1, null);
        }

        @JvmStatic
        @NotNull
        public final Object getOffer(@NotNull String offerId, @NotNull Function1<? super Response<Offer>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)offerId, (String)"offerId");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            return this.getDocumentClient$azuredata_release().getOffer(offerId, callback);
        }

        @JvmStatic
        public final <T extends Resource> void delete(@NotNull T resource, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().delete(resource, null, callback);
        }

        @JvmStatic
        public final <T extends Resource> void refresh(@NotNull T resource, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().refresh(resource, null, callback);
        }

        @JvmStatic
        public final <T extends Resource> void delete(@NotNull T resource, @NotNull String partitionKey, @NotNull Function1<? super Response<String>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().delete(resource, partitionKey, callback);
        }

        @JvmStatic
        public final <T extends Resource> void refresh(@NotNull T resource, @NotNull String partitionKey, @NotNull Function1<? super Response<T>, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)partitionKey, (String)"partitionKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getDocumentClient$azuredata_release().refresh(resource, partitionKey, callback);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

