/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.model.service;

import com.azure.core.http.HttpStatusCode;
import com.azure.data.model.service.DocumentClientError;
import com.azure.data.model.service.ServerError;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0013\b\u0016\u0012\n\u0010\u0006\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0002\u0010\u0007B\u0013\b\u0016\u0012\n\u0010\u0006\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u000bB\u001b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\rH\u0016R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/azure/data/model/service/DataError;", "Ljava/lang/Error;", "Lkotlin/Error;", "serverError", "Lcom/azure/data/model/service/ServerError;", "(Lcom/azure/data/model/service/ServerError;)V", "error", "(Ljava/lang/Error;)V", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;)V", "()V", "message", "", "code", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "isConnectivityError", "", "isInvalidCrossPartitionQueryError", "toString", "azuredata_release"})
public final class DataError
extends Error {
    @Nullable
    private final String code;

    @Override
    @NotNull
    public String toString() {
        return "Error: " + (this.code != null ? "\n\tCode: " + this.code : "") + " \n\tMessage: " + this.getMessage();
    }

    public final boolean isConnectivityError() {
        return StringsKt.equals$default((String)this.getMessage(), (String)DocumentClientError.Companion.getInternetConnectivityError().getMessage(), (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInvalidCrossPartitionQueryError() {
        if (!Intrinsics.areEqual((Object)this.code, (Object)HttpStatusCode.BadRequest.name())) return false;
        String string = this.getMessage();
        if (string == null) return false;
        String string2 = DocumentClientError.Companion.getInvalidCrossPartitionQueryError().getMessage();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public DataError(@Nullable String message, @Nullable String code) {
        super(message);
        this.code = code;
    }

    public /* synthetic */ DataError(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    public DataError(@NotNull ServerError serverError) {
        Intrinsics.checkParameterIsNotNull((Object)serverError, (String)"serverError");
        this(serverError.getMessage(), serverError.getCode());
    }

    public DataError(@NotNull Error error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this(error.getMessage(), null, 2, null);
    }

    public DataError(@NotNull Exception error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this(error.getMessage(), null, 2, null);
    }

    public DataError() {
        this("", null, 2, null);
    }
}

