/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import android.util.Base64;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.Charset;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

final class TokenParser {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    TokenParser() {
    }

    static CommunicationAccessToken createAccessToken(String tokenStr) {
        try {
            if (tokenStr == null) {
                throw new NullPointerException("'tokenStr' cannot be null.");
            }
            String[] tokenParts = tokenStr.split("\\.");
            String tokenPayload = tokenParts[1];
            byte[] decodedBytes = Base64.decode((String)tokenPayload, (int)0);
            String decodedPayloadJson = new String(decodedBytes, Charset.forName("UTF-8"));
            ObjectNode payloadObj = (ObjectNode)JSON_MAPPER.readValue(decodedPayloadJson, ObjectNode.class);
            long expire = payloadObj.get("exp").longValue();
            OffsetDateTime offsetExpiry = OffsetDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)(expire * 1000L)), (ZoneId)ZoneId.of((String)"UTC"));
            return new CommunicationAccessToken(tokenStr, offsetExpiry);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'tokenStr' is not a valid token string", e);
        }
    }
}

