/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationIdentifier;

public final class PhoneNumberIdentifier
extends CommunicationIdentifier {
    private final String phoneNumber;

    public PhoneNumberIdentifier(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.trim().length() == 0) {
            throw new IllegalArgumentException("The initialization parameter [phoneNumber] cannot be null to empty.");
        }
        this.phoneNumber = phoneNumber;
        this.setRawId("4:" + phoneNumber);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public PhoneNumberIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PhoneNumberIdentifier)) {
            return false;
        }
        PhoneNumberIdentifier phoneId = (PhoneNumberIdentifier)that;
        return this.getRawId() == null || phoneId.getRawId() == null || this.getRawId().equals(phoneId.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

