/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.core.logging.ClientLogger;
import java.util.concurrent.Callable;

public final class CommunicationTokenRefreshOptions {
    private final ClientLogger logger = new ClientLogger(CommunicationTokenRefreshOptions.class);
    private final Callable<String> tokenRefresher;
    private final boolean refreshProactively;
    private final String initialToken;

    public CommunicationTokenRefreshOptions(Callable<String> tokenRefresher, boolean refreshProactively) {
        if (tokenRefresher == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required parameters 'tokenRefresher'."));
        }
        this.tokenRefresher = tokenRefresher;
        this.refreshProactively = refreshProactively;
        this.initialToken = null;
    }

    public CommunicationTokenRefreshOptions(Callable<String> tokenRefresher, boolean refreshProactively, String initialToken) {
        if (tokenRefresher == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required parameters 'tokenRefresher'."));
        }
        if (initialToken == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required parameters 'initialToken'."));
        }
        this.tokenRefresher = tokenRefresher;
        this.refreshProactively = refreshProactively;
        this.initialToken = initialToken;
    }

    public Callable<String> getTokenRefresher() {
        return this.tokenRefresher;
    }

    public boolean isRefreshProactively() {
        return this.refreshProactively;
    }

    public String getInitialToken() {
        return this.initialToken;
    }
}

