/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.AutoRefreshUserCredential;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenRefreshOptions;
import com.azure.android.communication.common.StaticUserCredential;
import com.azure.android.communication.common.UserCredential;
import com.azure.android.core.logging.ClientLogger;
import java9.util.concurrent.CompletableFuture;

public final class CommunicationTokenCredential {
    private final ClientLogger logger = new ClientLogger(CommunicationTokenCredential.class);
    private final UserCredential userCredential;

    public CommunicationTokenCredential(String userToken) {
        this.userCredential = new StaticUserCredential(userToken);
    }

    public CommunicationTokenCredential(CommunicationTokenRefreshOptions tokenRefreshOptions) {
        this.userCredential = new AutoRefreshUserCredential(tokenRefreshOptions.getTokenRefresher(), tokenRefreshOptions.isRefreshProactively(), tokenRefreshOptions.getInitialToken());
    }

    public CompletableFuture<CommunicationAccessToken> getToken() {
        if (this.userCredential.isDisposed()) {
            return CompletableFuture.failedFuture((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("UserCredential has been disposed.")));
        }
        return this.userCredential.getToken();
    }

    public void dispose() {
        this.userCredential.dispose();
    }
}

