/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.TokenParser;
import com.azure.android.communication.common.UserCredential;
import com.azure.android.core.logging.ClientLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java9.util.concurrent.CompletableFuture;

final class AutoRefreshUserCredential
extends UserCredential {
    private static final String CREDENTIAL_DISPOSED = "UserCredential has been disposed.";
    private static final int ON_DEMAND_REFRESH_BUFFER_SECS = 120;
    private static final int PROACTIVE_REFRESH_BUFFER_SECS = 600;
    private final ClientLogger logger = new ClientLogger(AutoRefreshUserCredential.class);
    private final Callable<String> tokenRefreshCallable;
    private final boolean refreshProactively;
    private volatile CompletableFuture<CommunicationAccessToken> tokenFuture;
    private CompletableFuture<Void> tokenFutureUpdater;

    AutoRefreshUserCredential(Callable<String> tokenRefresher) {
        this(tokenRefresher, false);
    }

    AutoRefreshUserCredential(Callable<String> tokenRefresher, String initialToken) {
        this(tokenRefresher, false, initialToken);
    }

    AutoRefreshUserCredential(Callable<String> tokenRefresher, boolean refreshProactively) {
        this(tokenRefresher, refreshProactively, null);
    }

    AutoRefreshUserCredential(Callable<String> tokenRefresher, boolean refreshProactively, String initialToken) {
        this.tokenRefreshCallable = tokenRefresher;
        this.refreshProactively = refreshProactively;
        CommunicationAccessToken initialAccessToken = null;
        if (initialToken != null) {
            initialAccessToken = TokenParser.createAccessToken(initialToken);
            this.tokenFuture = CompletableFuture.completedFuture((Object)initialAccessToken);
        }
        if (this.refreshProactively) {
            this.scheduleTokenFutureUpdate(initialAccessToken);
        }
    }

    @Override
    public CompletableFuture<CommunicationAccessToken> getToken() {
        if (this.shouldRefreshOnDemand()) {
            this.updateTokenFuture();
        }
        return this.tokenFuture;
    }

    private boolean shouldRefreshOnDemand() {
        CompletableFuture<CommunicationAccessToken> tokenFuture = this.tokenFuture;
        if (tokenFuture == null || tokenFuture.isCancelled()) {
            return true;
        }
        if (tokenFuture.isDone()) {
            try {
                CommunicationAccessToken accessToken = (CommunicationAccessToken)tokenFuture.get();
                long refreshEpochSecond = accessToken.getExpiresAt().toEpochSecond() - 120L;
                long currentEpochSecond = System.currentTimeMillis() / 1000L;
                return currentEpochSecond >= refreshEpochSecond;
            }
            catch (InterruptedException | ExecutionException e) {
                return true;
            }
        }
        return false;
    }

    private synchronized void updateTokenFuture() {
        if (this.isDisposed()) {
            this.tokenFuture = CompletableFuture.failedFuture((Throwable)new IllegalStateException(CREDENTIAL_DISPOSED));
            return;
        }
        CompletableFuture<CommunicationAccessToken> tokenFuture = this.tokenFuture;
        if (tokenFuture != null && !tokenFuture.isDone() && !tokenFuture.isCancelled()) {
            return;
        }
        this.tokenFuture = CompletableFuture.supplyAsync(() -> {
            CommunicationAccessToken accessToken;
            if (this.isDisposed()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(CREDENTIAL_DISPOSED));
            }
            try {
                String tokenStr = this.tokenRefreshCallable.call();
                accessToken = TokenParser.createAccessToken(tokenStr);
            }
            catch (Exception e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e));
            }
            if (this.refreshProactively) {
                this.scheduleTokenFutureUpdate(accessToken);
            }
            return accessToken;
        });
    }

    private synchronized void scheduleTokenFutureUpdate(CommunicationAccessToken accessToken) {
        if (this.isDisposed()) {
            return;
        }
        if (this.tokenFutureUpdater != null) {
            this.tokenFutureUpdater.cancel(true);
        }
        long delayMs = 0L;
        if (accessToken != null) {
            long refreshEpochSecond = accessToken.getExpiresAt().toEpochSecond() - 600L;
            long currentEpochSecond = System.currentTimeMillis() / 1000L;
            delayMs = Math.max((refreshEpochSecond - currentEpochSecond) * 1000L, 0L);
        }
        this.tokenFutureUpdater = CompletableFuture.runAsync(this::updateTokenFuture, (Executor)CompletableFuture.delayedExecutor((long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Override
    public void dispose() {
        if (this.tokenFuture != null) {
            this.tokenFuture.cancel(true);
        }
        if (this.tokenFutureUpdater != null) {
            this.tokenFutureUpdater.cancel(true);
        }
        super.dispose();
    }
}

