/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Range;
import android.util.Size;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraRect;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.impl.CameraExtensions;
import com.microsoft.dl.video.capture.impl.real.impl.CameraCapabilitiesUtils;
import com.microsoft.dl.video.utils.Resolution;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class Camera2CapabilitiesUtils
extends CameraCapabilitiesUtils {
    private static final int FULL_ANGLE = 360;
    public static final int CAMERA_API_VERSION_2 = 2;

    private Camera2CapabilitiesUtils() {
    }

    private static void getCustomCameraCapabilities(String cameraId, CameraCharacteristics cameraInfo, CameraCapabilities caps) {
        CameraCapabilities.SmartCameraType cameraType;
        if (Build.VERSION.SDK_INT < 29) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("getCustomCameraCapabilities is not supported on Android Q below. [SDK_INT:" + Build.VERSION.SDK_INT + "]"));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("getCustomCameraCapabilities [" + cameraId + "]"));
        }
        if ((cameraType = Camera2CapabilitiesUtils.getSmartCameraType(cameraInfo)) != CameraCapabilities.SmartCameraType.INVALID) {
            caps.setSmartCameraType(cameraType);
            caps.setSmartCameraExtensionVersion(Camera2CapabilitiesUtils.getSmartCameraExtensionVersion(cameraInfo));
            caps.setSmartCameraDriverVersion(Camera2CapabilitiesUtils.getSmartCameraDriverVersion(cameraInfo));
        }
    }

    public static CameraCapabilities getCameraCapabilities(String cameraId) throws CaptureException {
        CameraCharacteristics cameraInfo = Camera2CapabilitiesUtils.getCameraInfo(cameraId);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("getCameraCapabilities for cameraId: " + cameraId));
        }
        CameraCapabilities capabilities = new CameraCapabilities();
        capabilities.setCameraId(cameraId);
        capabilities.setFacing(Camera2CapabilitiesUtils.getCameraFacing(cameraInfo));
        capabilities.setOrientation(Camera2CapabilitiesUtils.getCameraOrientation(cameraInfo));
        capabilities.setCameraArraySize(Camera2CapabilitiesUtils.getCameraArraySize(cameraInfo));
        capabilities.setSupportedImageFormats(Camera2CapabilitiesUtils.getImageFormats());
        capabilities.setSupportedResolutions(Camera2CapabilitiesUtils.getResolutions(cameraInfo));
        capabilities.setSupportedFpsRanges(Camera2CapabilitiesUtils.getFpsRanges(cameraInfo));
        capabilities.setSupportedFocusModes(Camera2CapabilitiesUtils.getFocusModes(cameraInfo));
        capabilities.setFlashUnitAvailability(Camera2CapabilitiesUtils.isFlashUnitAvailable(cameraInfo));
        capabilities.setNativeAspectRatio(Camera2CapabilitiesUtils.getNativeAspectRatio(cameraInfo));
        NavigableSet<Integer> detectionModes = Camera2CapabilitiesUtils.getFaceDetectModes(cameraInfo);
        capabilities.setSupportedFaceDetectModes(detectionModes);
        capabilities.setMaxFaceCount(Camera2CapabilitiesUtils.getMaxFaceCount(cameraInfo, detectionModes));
        if (capabilities.getFacing() == CameraCapabilities.Facing.EXTERNAL) {
            capabilities.setFriendlyName(Camera2CapabilitiesUtils.getFriendlyName(cameraInfo));
            capabilities.setManufacturer(Camera2CapabilitiesUtils.getManufacturer(cameraInfo));
            capabilities.setModel(Camera2CapabilitiesUtils.getModel(cameraInfo));
            capabilities.setPid(Camera2CapabilitiesUtils.getPID(cameraInfo));
            capabilities.setVid(Camera2CapabilitiesUtils.getVid(cameraInfo));
        }
        Camera2CapabilitiesUtils.getCustomCameraCapabilities(cameraId, cameraInfo, capabilities);
        return capabilities;
    }

    public static FpsRange mapFpsRange(Range<Integer> range) throws CaptureException {
        int min = (Integer)range.getLower();
        int max = (Integer)range.getUpper();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("FpsRange, min:" + min + "  max:" + max));
            Log.d((String)"Video", (String)("converting as per camera1 expectation , min:" + min * 1000 + "  max:" + max * 1000));
        }
        return new FpsRange(min * 1000, max * 1000);
    }

    public static Map<String, CameraCapabilities> obtain() throws CaptureException {
        Map<String, CameraCapabilities> capabilities = Camera2CapabilitiesUtils.collect();
        if (Log.isLoggable((String)"Video", (int)4)) {
            for (CameraCapabilities caps : capabilities.values()) {
                Log.i((String)"Video", (String)("obtain capabilities: " + caps.toString()));
            }
        }
        return capabilities;
    }

    private static Map<String, CameraCapabilities> collect() throws CaptureException {
        String[] idList;
        HashMap<String, CameraCapabilities> capabilities = new HashMap<String, CameraCapabilities>();
        for (String id : idList = CameraManagerSingleton.getInstance().getCameraIds()) {
            capabilities.put(id, Camera2CapabilitiesUtils.getCameraCapabilities(id));
        }
        return capabilities;
    }

    private static float getNativeAspectRatio(CameraCharacteristics cameraInfo) {
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraInfo.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        if (sizes != null) {
            return (float)sizes[0].getWidth() / (float)sizes[0].getHeight();
        }
        return 0.0f;
    }

    private static NavigableSet<ImageFormat> getImageFormats() {
        TreeSet<ImageFormat> imageFormats = new TreeSet<ImageFormat>();
        imageFormats.add(ImageFormat.NV21);
        return imageFormats;
    }

    private static NavigableSet<Resolution> getResolutions(CameraCharacteristics cameraInfo) throws CaptureException {
        TreeSet<Resolution> resolutions = new TreeSet<Resolution>();
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraInfo.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        if (sizes != null) {
            for (int i = 0; i < sizes.length; ++i) {
                resolutions.add(new Resolution(sizes[i].getWidth(), sizes[i].getHeight()));
                if (!Log.isLoggable((String)"Video", (int)3)) continue;
                Log.d((String)"Video", (String)("Resolutions, width: " + sizes[i].getWidth() + "height: " + sizes[i].getHeight()));
            }
        }
        return resolutions;
    }

    private static NavigableSet<FpsRange> getFpsRanges(CameraCharacteristics cameraInfo) throws CaptureException {
        TreeSet<FpsRange> fpsRanges = new TreeSet<FpsRange>();
        for (Range range : (Range[])cameraInfo.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) {
            fpsRanges.add(Camera2CapabilitiesUtils.mapFpsRange((Range<Integer>)range));
        }
        return fpsRanges;
    }

    private static NavigableSet<String> getFocusModes(CameraCharacteristics cameraInfo) {
        TreeSet<String> focusModes = new TreeSet<String>();
        for (int focusMode : (int[])cameraInfo.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)("focusModes: " + String.valueOf(focusMode)));
            }
            focusModes.add(String.valueOf(focusMode));
        }
        return focusModes;
    }

    private static boolean isFlashUnitAvailable(CameraCharacteristics cameraInfo) {
        if (((Boolean)cameraInfo.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)).booleanValue()) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"Flash Unit Available");
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"Flash Unit Not Available");
        }
        return false;
    }

    private static CameraCapabilities.Facing getCameraFacing(CameraCharacteristics cameraInfo) {
        switch ((Integer)cameraInfo.get(CameraCharacteristics.LENS_FACING)) {
            case 1: {
                return CameraCapabilities.Facing.BACK;
            }
            case 0: {
                return CameraCapabilities.Facing.FRONT;
            }
            case 2: {
                return CameraCapabilities.Facing.EXTERNAL;
            }
        }
        return CameraCapabilities.Facing.OTHER;
    }

    private static int getCameraOrientation(CameraCharacteristics cameraInfo) {
        Integer orientation = (Integer)cameraInfo.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("orientation:" + (360 - orientation)));
        }
        return 360 - orientation;
    }

    private static CameraRect getCameraArraySize(CameraCharacteristics cameraInfo) {
        Rect arraySize = (Rect)cameraInfo.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("array size: " + arraySize.toString()));
        }
        return new CameraRect(arraySize);
    }

    private static NavigableSet<Integer> getFaceDetectModes(CameraCharacteristics cameraInfo) {
        TreeSet<Integer> faceDetectModes = new TreeSet<Integer>();
        int[] faceDetectModeArray = (int[])cameraInfo.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        if (faceDetectModeArray != null) {
            for (int faceDetectMode : faceDetectModeArray) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("faceDetectModes:" + faceDetectMode));
                }
                if (faceDetectMode == 0) continue;
                faceDetectModes.add(faceDetectMode);
            }
        }
        return faceDetectModes;
    }

    private static Object getCustomKeyOrDefault(CameraCharacteristics cameraInfo, CameraCharacteristics.Key<?> key, Object defaultResult) {
        Object result = null;
        try {
            result = cameraInfo.get(key);
        }
        catch (Exception e) {
            Log.i((String)"Video", (String)("The key [" + key.getName() + "] is not supported by the device"));
        }
        return result == null ? defaultResult : result;
    }

    private static String getFriendlyName(CameraCharacteristics cameraInfo) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                CameraCharacteristics.Key friendlyNameKey = new CameraCharacteristics.Key("teams.camera.name", String.class);
                if (cameraInfo.getKeys().contains(friendlyNameKey)) {
                    return (String)cameraInfo.get(friendlyNameKey);
                }
                return null;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getFriendlyName exception", (Throwable)e);
            }
            return null;
        }
    }

    private static String getManufacturer(CameraCharacteristics cameraInfo) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                CameraCharacteristics.Key manufacturerKey = new CameraCharacteristics.Key("teams.camera.manufacturer", String.class);
                if (cameraInfo.getKeys().contains(manufacturerKey)) {
                    return (String)cameraInfo.get(manufacturerKey);
                }
                return null;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getManufacturer exception", (Throwable)e);
            }
            return null;
        }
    }

    private static String getModel(CameraCharacteristics cameraInfo) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                CameraCharacteristics.Key modelKey = new CameraCharacteristics.Key("teams.camera.model", String.class);
                if (cameraInfo.getKeys().contains(modelKey)) {
                    return (String)cameraInfo.get(modelKey);
                }
                return null;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getModel exception", (Throwable)e);
            }
            return null;
        }
    }

    private static int getPID(CameraCharacteristics cameraInfo) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                CameraCharacteristics.Key pidKey = new CameraCharacteristics.Key("teams.camera.pid", Integer.class);
                if (cameraInfo.getKeys().contains(pidKey)) {
                    return (Integer)cameraInfo.get(pidKey);
                }
                return 0;
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getPID exception", (Throwable)e);
            }
            return 0;
        }
    }

    private static int getVid(CameraCharacteristics cameraInfo) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                CameraCharacteristics.Key vidKey = new CameraCharacteristics.Key("teams.camera.vid", Integer.class);
                if (cameraInfo.getKeys().contains(vidKey)) {
                    return (Integer)cameraInfo.get(vidKey);
                }
                return 0;
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getVid exception", (Throwable)e);
            }
            return 0;
        }
    }

    private static CameraCapabilities.SmartCameraType getSmartCameraType(CameraCharacteristics cameraInfo) {
        CameraCapabilities.SmartCameraType cameraType = CameraCapabilities.SmartCameraType.fromInteger((Integer)Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_TYPE, 0));
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("smartCameraType: " + (Object)((Object)cameraType)));
        }
        return cameraType;
    }

    private static int getSmartCameraExtensionVersion(CameraCharacteristics cameraInfo) {
        int extensionVersion = (Integer)Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_EXTENSION_VERSION, 0);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("extensionVersion: " + extensionVersion));
        }
        return extensionVersion;
    }

    private static int getSmartCameraDriverVersion(CameraCharacteristics cameraInfo) {
        int driverVersion = (Integer)Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_DRIVER_VERSION, 0);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("driverVersion: " + driverVersion));
        }
        return driverVersion;
    }

    private static int getSmartCameraIntelliFrameIndex(CameraCharacteristics cameraInfo) {
        int intelliFrameIndex = (Integer)Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_INTELLI_FRAME_INDEX, 0);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("intelliFrameIndex: " + intelliFrameIndex));
        }
        return intelliFrameIndex;
    }

    private static int getMaxFaceCount(CameraCharacteristics cameraInfo, NavigableSet<Integer> detectionModes) {
        int maxFaceCount = (Integer)cameraInfo.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("maxFaceCount:" + maxFaceCount));
        }
        if (detectionModes == null || detectionModes.size() == 0) {
            maxFaceCount = 0;
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Reset maxFaceCount to 0 cause not supported face detection mode enable.");
            }
        }
        return maxFaceCount;
    }

    private static CameraCharacteristics getCameraInfo(String cameraId) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"getCameraInfo starts");
        }
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        CameraCharacteristics characteristics = null;
        try {
            characteristics = cameraManager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException("Could not get CameraInfo for the camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_GET_INFO_FAILED);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException("Could not get CameraInfo for the camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_GET_INFO_FAILED);
        }
        return characteristics;
    }
}

