/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl;

import android.hardware.Camera;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraRect;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.utils.Resolution;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public class CameraCapabilitiesUtils {
    private static final String CACHE_FILE_NAME = "camera_capabilities";
    private static final int FULL_ANGLE = 360;
    private static final int CAMERA_API_VERSION_1 = 1;

    protected CameraCapabilitiesUtils() {
    }

    public static Map<String, CameraCapabilities> obtain() throws CaptureException {
        Map<String, CameraCapabilities> capabilities = CameraCapabilitiesUtils.collect();
        if (Log.isLoggable((String)"Video", (int)4)) {
            for (CameraCapabilities caps : capabilities.values()) {
                Log.i((String)"Video", (String)("obtain capabilities: " + caps.toString()));
            }
        }
        return capabilities;
    }

    public static ImageFormat mapImageFormat(int format) {
        switch (format) {
            case 17: {
                return ImageFormat.NV21;
            }
        }
        return null;
    }

    public static int mapImageFormat(ImageFormat format) throws CaptureException {
        switch (format) {
            case NV21: {
                return 17;
            }
            case YV12: {
                return 842094169;
            }
            case NV16: {
                return 16;
            }
            case YUY2: {
                return 20;
            }
        }
        throw new CaptureException("Could not map ImageFormat " + format.toString(), ErrorCode.ANDROID_CAMERA_IMAGE_FORMAT_MAPPING_FAILED);
    }

    public static Resolution mapResolution(Camera.Size size) throws CaptureException {
        return new Resolution(size.width, size.height);
    }

    public static FpsRange mapFpsRange(int[] range) throws CaptureException {
        int min = range[0];
        int max = range[1];
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("FpsRange, min:" + min + "  max:" + max));
        }
        return new FpsRange(min, max);
    }

    public static boolean isPictureSizeSupported(Resolution resolution, Camera.Parameters cameraParameters) {
        for (Camera.Size s : cameraParameters.getSupportedPictureSizes()) {
            if (s.width != resolution.getWidth() || s.height != resolution.getHeight()) continue;
            return true;
        }
        return false;
    }

    private static Map<String, CameraCapabilities> collect() throws CaptureException {
        String[] idList;
        HashMap<String, CameraCapabilities> capabilities = new HashMap<String, CameraCapabilities>();
        for (String id : idList = CameraManagerSingleton.getInstance().getCameraIds()) {
            try {
                int idInt = Integer.parseInt(id);
                capabilities.put(id, CameraCapabilitiesUtils.getCameraCapabilities(idInt));
            }
            catch (NumberFormatException exception) {
                throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
        }
        return capabilities;
    }

    public static Map<String, StaticCameraCapabilities> obtainStatic() throws CaptureException {
        String[] idList;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"obtainStatic start");
        }
        HashMap<String, StaticCameraCapabilities> staticCapabilities = new HashMap<String, StaticCameraCapabilities>();
        for (String id : idList = CameraManagerSingleton.getInstance().getCameraIds()) {
            try {
                int idInt = Integer.parseInt(id);
                staticCapabilities.put(id, CameraCapabilitiesUtils.getStaticCameraCapabilities(idInt));
            }
            catch (NumberFormatException exception) {
                throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
        }
        return staticCapabilities;
    }

    private static StaticCameraCapabilities getStaticCameraCapabilities(int cameraId) throws CaptureException {
        Camera.CameraInfo cameraInfo = CameraCapabilitiesUtils.getCameraInfo(cameraId);
        StaticCameraCapabilities staticCapabilities = new StaticCameraCapabilities();
        staticCapabilities.setCameraId(String.valueOf(cameraId));
        staticCapabilities.setFacing(CameraCapabilitiesUtils.getCameraFacing(cameraInfo));
        staticCapabilities.setOrientation(CameraCapabilitiesUtils.getCameraOrientation(cameraInfo));
        staticCapabilities.setCameraArraySize(CameraCapabilitiesUtils.getCameraArraySize());
        return staticCapabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CameraCapabilities getCameraCapabilities(int cameraId) throws CaptureException {
        Camera.CameraInfo cameraInfo = CameraCapabilitiesUtils.getCameraInfo(cameraId);
        Camera camera = CameraCapabilitiesUtils.openCamera(cameraId);
        Camera.Parameters cameraParameters = camera.getParameters();
        try {
            CameraCapabilities capabilities = new CameraCapabilities();
            capabilities.setCameraId(String.valueOf(cameraId));
            capabilities.setFacing(CameraCapabilitiesUtils.getCameraFacing(cameraInfo));
            capabilities.setOrientation(CameraCapabilitiesUtils.getCameraOrientation(cameraInfo));
            capabilities.setCameraArraySize(CameraCapabilitiesUtils.getCameraArraySize());
            capabilities.setSupportedImageFormats(CameraCapabilitiesUtils.getImageFormats(cameraParameters));
            capabilities.setSupportedResolutions(CameraCapabilitiesUtils.getResolutions(cameraParameters));
            capabilities.setSupportedFpsRanges(CameraCapabilitiesUtils.getFpsRanges(cameraParameters));
            capabilities.setSupportedFocusModes(CameraCapabilitiesUtils.getFocusModes(cameraParameters));
            capabilities.setFlashUnitAvailability(CameraCapabilitiesUtils.isFlashUnitAvailable(cameraParameters));
            capabilities.setNativeAspectRatio(CameraCapabilitiesUtils.getNativeAspectRatio(cameraParameters));
            capabilities.setSupportedFaceDetectModes(CameraCapabilitiesUtils.getFaceDetectModes(cameraParameters));
            capabilities.setMaxFaceCount(CameraCapabilitiesUtils.getMaxFaceCount(cameraParameters));
            CameraCapabilities cameraCapabilities = capabilities;
            return cameraCapabilities;
        }
        finally {
            camera.release();
        }
    }

    private static NavigableSet<Integer> getFaceDetectModes(Camera.Parameters cameraParameters) {
        return new TreeSet<Integer>();
    }

    private static int getMaxFaceCount(Camera.Parameters cameraParameters) {
        int maxFaceCount = cameraParameters.getMaxNumDetectedFaces();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("maxFaceCount:" + maxFaceCount));
        }
        return maxFaceCount;
    }

    private static CameraRect getCameraArraySize() {
        return new CameraRect(-1000, -1000, 1000, 1000);
    }

    private static float getNativeAspectRatio(Camera.Parameters cameraParameters) {
        Camera.Size maxPictureSize = Collections.max(cameraParameters.getSupportedPictureSizes(), new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size left, Camera.Size right) {
                return Integer.signum(left.width * left.height - right.width * right.height);
            }
        });
        return (float)maxPictureSize.width / (float)maxPictureSize.height;
    }

    private static NavigableSet<ImageFormat> getImageFormats(Camera.Parameters cameraParameters) {
        TreeSet<ImageFormat> imageFormats = new TreeSet<ImageFormat>();
        for (Integer format : cameraParameters.getSupportedPreviewFormats()) {
            ImageFormat imageFormat = CameraCapabilitiesUtils.mapImageFormat(format);
            if (imageFormat != null) {
                imageFormats.add(imageFormat);
                continue;
            }
            if (!Log.isLoggable((String)"Video", (int)3)) continue;
            Log.d((String)"Video", (String)("Unknown image format " + format + ", skipping"));
        }
        return imageFormats;
    }

    private static NavigableSet<Resolution> getResolutions(Camera.Parameters cameraParameters) throws CaptureException {
        TreeSet<Resolution> resolutions = new TreeSet<Resolution>();
        for (Camera.Size size : cameraParameters.getSupportedPreviewSizes()) {
            resolutions.add(CameraCapabilitiesUtils.mapResolution(size));
        }
        return resolutions;
    }

    private static NavigableSet<FpsRange> getFpsRanges(Camera.Parameters cameraParameters) throws CaptureException {
        TreeSet<FpsRange> fpsRanges = new TreeSet<FpsRange>();
        for (int[] range : cameraParameters.getSupportedPreviewFpsRange()) {
            fpsRanges.add(CameraCapabilitiesUtils.mapFpsRange(range));
        }
        return fpsRanges;
    }

    private static NavigableSet<String> getFocusModes(Camera.Parameters cameraParameters) {
        TreeSet<String> focusModes = new TreeSet<String>();
        for (String focusMode : cameraParameters.getSupportedFocusModes()) {
            focusModes.add(focusMode);
            if (!Log.isLoggable((String)"Video", (int)3)) continue;
            Log.d((String)"Video", (String)("focusModes: " + focusMode));
        }
        return focusModes;
    }

    private static boolean isFlashUnitAvailable(Camera.Parameters cameraParameters) {
        if (cameraParameters.getSupportedFlashModes() != null) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"Flash Unit is Available");
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"Flash Unit is not Available");
        }
        return false;
    }

    private static CameraCapabilities.Facing getCameraFacing(Camera.CameraInfo cameraInfo) {
        switch (cameraInfo.facing) {
            case 0: {
                return CameraCapabilities.Facing.BACK;
            }
            case 1: {
                return CameraCapabilities.Facing.FRONT;
            }
        }
        return CameraCapabilities.Facing.OTHER;
    }

    private static int getCameraOrientation(Camera.CameraInfo cameraInfo) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("orientation:" + (360 - cameraInfo.orientation)));
        }
        return 360 - cameraInfo.orientation;
    }

    private static Camera.CameraInfo getCameraInfo(int cameraId) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"getCameraInfo starts");
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not get CameraInfo for the camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_GET_INFO_FAILED);
        }
        return cameraInfo;
    }

    private static Camera openCamera(int cameraId) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("openCamera Id: " + cameraId));
        }
        Camera camera = null;
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
        if (camera == null) {
            throw new CaptureException("Could not open camera " + cameraId, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
        return camera;
    }
}

