/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RawOutgoingVideoStream;
import com.azure.android.communication.calling.RawOutgoingVideoStreamOptions;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoStreamFormatChangedEvent;
import com.azure.android.communication.calling.VideoStreamFormatChangedListener;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamStateChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class VirtualOutgoingVideoStream
extends RawOutgoingVideoStream {
    private List<VideoStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<VideoStreamStateChangedListener>();
    private List<VideoStreamFormatChangedListener> OnFormatChangedListeners = new CopyOnWriteArrayList<VideoStreamFormatChangedListener>();

    VirtualOutgoingVideoStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    VirtualOutgoingVideoStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(RawOutgoingVideoStreamOptions videoStreamOptions) {
        long videoStreamOptions_converted = videoStreamOptions != null ? videoStreamOptions.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_virtual_outgoing_video_stream_create_raw_outgoing_video_stream_options_video_stream_options(videoStreamOptions_converted, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public VirtualOutgoingVideoStream(RawOutgoingVideoStreamOptions videoStreamOptions) {
        super(VirtualOutgoingVideoStream.Create(videoStreamOptions), true);
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        VirtualOutgoingVideoStream instance = VirtualOutgoingVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoStreamStateChangedEvent args_converted = args != 0L ? VideoStreamStateChangedEvent.getInstance(args, false) : null;
            for (VideoStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onVideoStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_virtual_outgoing_video_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_virtual_outgoing_video_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    private static void OnFormatChangedStaticHandler(long cookie, long args) {
        VirtualOutgoingVideoStream instance = VirtualOutgoingVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoStreamFormatChangedEvent args_converted = args != 0L ? VideoStreamFormatChangedEvent.getInstance(args, false) : null;
            for (VideoStreamFormatChangedListener listener : instance.OnFormatChangedListeners) {
                listener.onVideoStreamFormatChanged(args_converted);
            }
        }
    }

    public void addOnFormatChangedListener(VideoStreamFormatChangedListener listener) {
        this.OnFormatChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnFormatChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_virtual_outgoing_video_stream_set_on_format_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnFormatChangedListener(VideoStreamFormatChangedListener listener) {
        this.OnFormatChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnFormatChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_virtual_outgoing_video_stream_set_on_format_changed(this.handle, 0L, null));
        }
    }

    static VirtualOutgoingVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VirtualOutgoingVideoStream, VirtualOutgoingVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VirtualOutgoingVideoStream, VirtualOutgoingVideoStream.class, false);
    }

    private static VirtualOutgoingVideoStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VirtualOutgoingVideoStream, VirtualOutgoingVideoStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((VideoStreamStateChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnFormatChanged")) {
            this.addOnFormatChangedListener((VideoStreamFormatChangedListener)eventListener);
        }
    }
}

