/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.graphics.Matrix;
import android.graphics.Point;
import android.view.TextureView;

class ViewScaleHelper {
    ViewScaleHelper() {
    }

    public static void scaleView(TextureView view, int viewWidth, int viewHeight, int videoWidth, int videoHeight, boolean scaleToFit, Point offset) {
        if (view == null || !view.isAvailable()) {
            return;
        }
        float scaleWidth = (float)viewWidth / (float)videoWidth;
        float scaleHeight = (float)viewHeight / (float)videoHeight;
        Matrix matrix = view.getTransform(null);
        float scale = scaleToFit ? Math.min(scaleWidth, scaleHeight) : Math.max(scaleWidth, scaleHeight);
        int sw = (int)(scale * (float)videoWidth);
        int sh = (int)(scale * (float)videoHeight);
        float scaleX = (float)sw / (float)viewWidth;
        float scaleY = (float)sh / (float)viewHeight;
        matrix.setScale(scaleX, scaleY);
        if (scaleToFit) {
            float translateX = (float)(viewWidth - sw) / 2.0f;
            float translateY = (float)(viewHeight - sh) / 2.0f;
            matrix.postTranslate(translateX, translateY);
        } else {
            float x = (float)(viewWidth - sw) / 2.0f + (float)offset.x;
            float y = (float)(viewHeight - sh) / 2.0f + (float)offset.y;
            float translateX = ViewScaleHelper.clampValue(x, viewWidth - sw, 0.0f);
            float translateY = ViewScaleHelper.clampValue(y, viewHeight - sh, 0.0f);
            matrix.postTranslate(translateX, translateY);
            offset.x = (int)((float)offset.x + (translateX - x));
            offset.y = (int)((float)offset.y + (translateY - y));
        }
        view.setTransform(matrix);
    }

    private static float clampValue(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }
}

