/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.VideoStreamFormat;

public final class VideoStreamFormatChangedEvent {
    long handle;

    VideoStreamFormatChangedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_stream_format_changed_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_changed_event_args_release(this.handle));
        this.handle = 0L;
    }

    public VideoStreamFormat getFormat() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_changed_event_args_get_format(this.handle, result_handle));
        VideoStreamFormat result_object = (Long)result_handle.value != 0L ? VideoStreamFormat.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static VideoStreamFormatChangedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamFormatChangedEvent, VideoStreamFormatChangedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_stream_format_changed_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamFormatChangedEvent, VideoStreamFormatChangedEvent.class, false);
    }
}

