/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

final class SwitchSourceTelemetryEvent {
    long handle;

    SwitchSourceTelemetryEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_switch_source_telemetry_event_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public SwitchSourceTelemetryEvent(LocalVideoStream localStream) {
        long localStream_converted = localStream != null ? localStream.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_switch_source_telemetry_event_create_local_video_stream_local_stream(localStream_converted, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_switch_source_telemetry_event_release(this.handle));
        this.handle = 0L;
    }

    public void sendAttempt() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_switch_source_telemetry_event_send_attempt(this.handle));
    }

    public void sendSuccess() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_switch_source_telemetry_event_send_success(this.handle));
    }

    public void sendFailure(String reason) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_switch_source_telemetry_event_send_failure(this.handle, reason));
    }

    static SwitchSourceTelemetryEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SwitchSourceTelemetryEvent, SwitchSourceTelemetryEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_switch_source_telemetry_event_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SwitchSourceTelemetryEvent, SwitchSourceTelemetryEvent.class, false);
    }
}

