/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.IncomingVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.VideoStreamRenderer;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamStateChangedListener;
import com.azure.android.communication.calling.VideoStreamView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RemoteVideoStream
extends IncomingVideoStream {
    private List<VideoStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<VideoStreamStateChangedListener>();

    RemoteVideoStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RemoteVideoStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    @Deprecated
    public boolean isAvailable() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_get_is_available(this.handle, result));
        return (Boolean)result.value;
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        RemoteVideoStream instance = RemoteVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoStreamStateChangedEvent args_converted = args != 0L ? VideoStreamStateChangedEvent.getInstance(args, false) : null;
            for (VideoStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onVideoStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    private void startPreviewInternal(long videoBindingEventHandle, int videoBindingType) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_start_preview_internal(this.handle, videoBindingEventHandle, videoBindingType));
    }

    private void stopPreviewInternal() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_stop_preview_internal(this.handle));
    }

    static RemoteVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, false);
    }

    private static RemoteVideoStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((VideoStreamStateChangedListener)eventListener);
        }
    }

    void startPreviewNative(long videoBindingEventHandle, int videoBindingType) {
        this.startPreviewInternal(videoBindingEventHandle, videoBindingType);
    }

    void stopPreviewNative() {
        this.stopPreviewInternal();
    }

    VideoStreamView startPreview(Context context) {
        return this.startPreview(context, new CreateViewOptions(ScalingMode.CROP));
    }

    VideoStreamView startPreview(Context context, CreateViewOptions options) {
        IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.GetInstance(this.handle);
        if (videoStreamRenderer != null) {
            throw new RuntimeException("There is already a view attached");
        }
        videoStreamRenderer = VideoStreamRenderer.CreateInstance(this.handle, context, this);
        return videoStreamRenderer.StartPreview(options);
    }

    void stopPreview() {
        IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.GetInstance(this.handle);
        if (videoStreamRenderer != null) {
            videoStreamRenderer.StopPreview();
            VideoStreamRenderer.RemoveInstance(this.handle);
        }
    }
}

