/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.view.TextureView;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoStreamView;
import com.skype.android.video.render.GLTextureView;
import java.io.Closeable;
import java.io.IOException;

class RemoteIncomingVideoStreamView
extends VideoStreamView
implements GLTextureView.SurfaceTextureAvailableListener,
Closeable {
    private static final String TAG = "RemoteIncomingVideoStreamView";

    RemoteIncomingVideoStreamView(Context context, int videoId, ScalingMode scalingMode) {
        super(context, videoId, scalingMode);
        this.textureView = new GLTextureView(context, null, false, (GLTextureView.SurfaceTextureAvailableListener)this);
        this.textureView.setVisibility(0);
        this.textureView.layout(0, 0, this.getRight(), this.getBottom());
        Log.debug1(TAG, "TextureView created viewId: %d", System.identityHashCode(this.textureView));
        this.AddTextureView();
    }

    void UpdateVideoFrameSize(int w, int h) {
        Log.debug1(TAG, "UpdateVideoFrameSize new w: %d x h: %d, old w: %d x h: %d", w, h, this.w, this.h);
        this.streamSize = new StreamSize(w, h);
        this.w = w;
        this.h = h;
        this.ScaleTextureView();
    }

    public void onSurfaceTextureAvailable(TextureView textureView) {
        Log.debug1(TAG, "onSurfaceTextureAvailable videoId: %d, viewId", this.videoId, System.identityHashCode(textureView));
        this.ScaleTextureView();
    }

    @Override
    public void close() throws IOException {
        this.RemoveTextureView();
    }
}

