/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoStreamFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RawOutgoingVideoStreamOptions {
    long handle;

    RawOutgoingVideoStreamOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_raw_outgoing_video_stream_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public RawOutgoingVideoStreamOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_outgoing_video_stream_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_video_stream_options_release(this.handle));
        this.handle = 0L;
    }

    public List<VideoStreamFormat> getFormats() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_video_stream_options_get_formats(this.handle, result, result_length));
        ArrayList<VideoStreamFormat> resultList = new ArrayList<VideoStreamFormat>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(VideoStreamFormat.getInstance(resultArray[i], true));
        }
        List<VideoStreamFormat> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private void setFormatsInternal(VideoStreamFormat[] videoStreamFormats) {
        long[] videoStreamFormats_converted = new long[videoStreamFormats.length];
        for (int i = 0; i < videoStreamFormats.length; ++i) {
            videoStreamFormats_converted[i] = videoStreamFormats[i].handle;
        }
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_video_stream_options_set_formats_internal(this.handle, videoStreamFormats_converted, videoStreamFormats.length));
    }

    static RawOutgoingVideoStreamOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingVideoStreamOptions, RawOutgoingVideoStreamOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_outgoing_video_stream_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingVideoStreamOptions, RawOutgoingVideoStreamOptions.class, false);
    }

    public void setFormats(List<VideoStreamFormat> videoStreamFormatList) {
        VideoStreamFormat[] videoFormatArray = new VideoStreamFormat[videoStreamFormatList.size()];
        for (int i = 0; i < videoStreamFormatList.size(); ++i) {
            videoFormatArray[i] = videoStreamFormatList.get(i);
        }
        this.setFormatsInternal(videoFormatArray);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

