/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawAudioStreamOptions;
import com.azure.android.communication.calling.RawIncomingAudioStreamProperties;
import com.azure.android.communication.calling.Status;

public final class RawIncomingAudioStreamOptions
extends RawAudioStreamOptions {
    RawIncomingAudioStreamOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_incoming_audio_stream_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawIncomingAudioStreamOptions() {
        super(RawIncomingAudioStreamOptions.Create(), true);
    }

    public RawIncomingAudioStreamProperties getProperties() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_options_get_properties(this.handle, result_handle));
        RawIncomingAudioStreamProperties result_object = (Long)result_handle.value != 0L ? RawIncomingAudioStreamProperties.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public RawIncomingAudioStreamOptions setProperties(RawIncomingAudioStreamProperties value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_options_set_properties(this.handle, value_converted));
        return this;
    }

    static RawIncomingAudioStreamOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStreamOptions, RawIncomingAudioStreamOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_audio_stream_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStreamOptions, RawIncomingAudioStreamOptions.class, false);
    }
}

