/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamStateChangedEvent;
import com.azure.android.communication.calling.AudioStreamStateChangedListener;
import com.azure.android.communication.calling.IncomingAudioStream;
import com.azure.android.communication.calling.IncomingMixedAudioEvent;
import com.azure.android.communication.calling.IncomingMixedAudioListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RawIncomingAudioStreamOptions;
import com.azure.android.communication.calling.Status;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RawIncomingAudioStream
extends IncomingAudioStream {
    private List<IncomingMixedAudioListener> OnMixedAudioBufferReceivedListeners = new CopyOnWriteArrayList<IncomingMixedAudioListener>();
    private List<AudioStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<AudioStreamStateChangedListener>();

    RawIncomingAudioStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RawIncomingAudioStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(RawIncomingAudioStreamOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_incoming_audio_stream_create_raw_incoming_audio_stream_options_options(options_converted, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawIncomingAudioStream(RawIncomingAudioStreamOptions options) {
        super(RawIncomingAudioStream.Create(options), true);
    }

    private static void OnMixedAudioBufferReceivedStaticHandler(long cookie, long args) {
        RawIncomingAudioStream instance = RawIncomingAudioStream.getInstance(cookie);
        if (instance != null) {
            IncomingMixedAudioEvent args_converted = args != 0L ? IncomingMixedAudioEvent.getInstance(args, false) : null;
            for (IncomingMixedAudioListener listener : instance.OnMixedAudioBufferReceivedListeners) {
                listener.onIncomingMixedAudio(args_converted);
            }
        }
    }

    public void addOnMixedAudioBufferReceivedListener(IncomingMixedAudioListener listener) {
        this.OnMixedAudioBufferReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnMixedAudioBufferReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_set_on_mixed_audio_buffer_received(this.handle, this.getHandle(), this));
    }

    public void removeOnMixedAudioBufferReceivedListener(IncomingMixedAudioListener listener) {
        this.OnMixedAudioBufferReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnMixedAudioBufferReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_set_on_mixed_audio_buffer_received(this.handle, 0L, null));
        }
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        RawIncomingAudioStream instance = RawIncomingAudioStream.getInstance(cookie);
        if (instance != null) {
            AudioStreamStateChangedEvent args_converted = args != 0L ? AudioStreamStateChangedEvent.getInstance(args, false) : null;
            for (AudioStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onAudioStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_incoming_audio_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    static RawIncomingAudioStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStream, RawIncomingAudioStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_audio_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStream, RawIncomingAudioStream.class, false);
    }

    private static RawIncomingAudioStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStream, RawIncomingAudioStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnMixedAudioBufferReceived")) {
            this.addOnMixedAudioBufferReceivedListener((IncomingMixedAudioListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((AudioStreamStateChangedListener)eventListener);
        }
    }
}

