/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.nio.ByteBuffer;

public final class RawAudioBuffer
implements AutoCloseable {
    long handle;

    RawAudioBuffer(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_raw_audio_buffer_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public RawAudioBuffer() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_audio_buffer_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_release(this.handle));
        this.handle = 0L;
    }

    public ByteBuffer getBuffer() {
        Out<ByteBuffer> result = new Out<ByteBuffer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_get_buffer(this.handle, result));
        return (ByteBuffer)result.value;
    }

    public RawAudioBuffer setBuffer(ByteBuffer value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_set_buffer(this.handle, value));
        return this;
    }

    public long getTimestampInTicks() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_get_timestamp_in_ticks(this.handle, result));
        return (Long)result.value;
    }

    public RawAudioBuffer setTimestampInTicks(long value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_set_timestamp_in_ticks(this.handle, value));
        return this;
    }

    @Override
    public void close() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_buffer_dispose(this.handle));
    }

    static RawAudioBuffer getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawAudioBuffer, RawAudioBuffer.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_audio_buffer_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawAudioBuffer, RawAudioBuffer.class, false);
    }
}

