/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.PushNotificationEventType;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.UUID;

public final class PushNotificationInfo {
    long handle;

    PushNotificationInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_push_notification_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_release(this.handle));
        this.handle = 0L;
    }

    public String getFromDisplayName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_from_display_name(this.handle, result));
        return (String)result.value;
    }

    public boolean isIncomingWithVideo() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_incoming_with_video(this.handle, result));
        return (Boolean)result.value;
    }

    private String getFromInternal() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_from_internal(this.handle, result));
        return (String)result.value;
    }

    private String getToInternal() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_to_internal(this.handle, result));
        return (String)result.value;
    }

    private String getCallIdInternal() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_call_id_internal(this.handle, result));
        return (String)result.value;
    }

    public PushNotificationEventType getEventType() {
        Out<PushNotificationEventType> result = new Out<PushNotificationEventType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_push_notification_info_get_event_type(this.handle, result));
        return (PushNotificationEventType)((Object)result.value);
    }

    private static PushNotificationInfo parseInternal(String payload) {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(NativeLibrary.sam_push_notification_info_parse_internal(payload, result_handle));
        PushNotificationInfo result_object = (Long)result_handle.value != 0L ? PushNotificationInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static PushNotificationInfo getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.PushNotificationInfo, PushNotificationInfo.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_push_notification_info_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.PushNotificationInfo, PushNotificationInfo.class, false);
    }

    public CommunicationIdentifier getFrom() {
        return IdentifierHelpers.from(this.getFromInternal());
    }

    public CommunicationIdentifier getTo() {
        return IdentifierHelpers.from(this.getToInternal());
    }

    public UUID getCallId() {
        return UUID.fromString(this.getCallIdInternal());
    }

    private static String extractNotificationMessage(Map<String, String> notificationMap) {
        JsonObject newObject = new JsonObject();
        for (Map.Entry<String, String> mapValue : notificationMap.entrySet()) {
            String key = mapValue.getKey();
            String value = mapValue.getValue();
            if (value.contains("{")) {
                newObject.add(key, JsonParser.parseString((String)value));
                continue;
            }
            if (key.equalsIgnoreCase("eventType")) {
                newObject.addProperty(key, (Number)Integer.valueOf(value));
                continue;
            }
            newObject.addProperty(key, value);
        }
        JsonObject topLevelObject = new JsonObject();
        topLevelObject.add("data", (JsonElement)newObject);
        return topLevelObject.toString();
    }

    public static PushNotificationInfo fromMap(Map<String, String> payload) {
        CallClient.loadNativeLibraries();
        return PushNotificationInfo.parseInternal(PushNotificationInfo.extractNotificationMessage(payload));
    }
}

