/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.os.Build;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.OutgoingVideoOptions;
import com.azure.android.communication.calling.VideoOptions;

class PermissionUtility {
    PermissionUtility() {
    }

    static boolean hasAudioPermission(Context context) {
        if (Build.VERSION.SDK_INT > 23) {
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    static boolean hasVideoPermission(Context context) {
        if (Build.VERSION.SDK_INT > 23) {
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
    }

    static boolean hasAudioAndVideoPermission(Context context) {
        return PermissionUtility.hasAudioPermission(context) && PermissionUtility.hasVideoPermission(context);
    }

    static CallingCommunicationErrors determineErrorCode(boolean hasAudioPermissions, boolean hasVideoPermissions) {
        if (!hasAudioPermissions && !hasVideoPermissions) {
            return CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION;
        }
        if (!hasAudioPermissions) {
            return CallingCommunicationErrors.NO_AUDIO_PERMISSION;
        }
        return CallingCommunicationErrors.NO_VIDEO_PERMISSION;
    }

    static void throwIfNotAppropriatePermissions(Context context, VideoOptions videoOptions, AudioOptions audioOptions) {
        boolean requiresVideoPermission = false;
        boolean requiresAudioPermission = false;
        if (videoOptions != null) {
            requiresVideoPermission = true;
        }
        if (audioOptions != null && !audioOptions.isMuted()) {
            requiresAudioPermission = true;
        }
        PermissionUtility.throwIfNotAppropriatePermissions(context, requiresAudioPermission, requiresVideoPermission);
    }

    static void throwIfNotAppropriatePermissions(Context context, OutgoingVideoOptions outgoingVideoOptions, OutgoingAudioOptions outgoingAudioOptions) {
        boolean requiresVideoPermission = false;
        boolean requiresAudioPermission = false;
        if (outgoingVideoOptions != null) {
            requiresVideoPermission = true;
        }
        if (outgoingAudioOptions != null && !outgoingAudioOptions.isMuted()) {
            requiresAudioPermission = true;
        }
        PermissionUtility.throwIfNotAppropriatePermissions(context, requiresAudioPermission, requiresVideoPermission);
    }

    static void throwIfNotAppropriatePermissions(Context context, boolean requiresAudio, boolean requiresVideo) {
        boolean hasAudioPermission = true;
        boolean hasVideoPermission = true;
        if (requiresAudio) {
            hasAudioPermission = PermissionUtility.hasAudioPermission(context);
        }
        if (requiresVideo) {
            hasVideoPermission = PermissionUtility.hasVideoPermission(context);
        }
        if (!hasAudioPermission || !hasVideoPermission) {
            throw new CallingCommunicationException(PermissionUtility.determineErrorCode(hasAudioPermission, hasVideoPermission));
        }
    }
}

