/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.NoiseSuppressionMode;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class OutgoingAudioFilters {
    long handle;

    OutgoingAudioFilters(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_audio_filters_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public OutgoingAudioFilters() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_outgoing_audio_filters_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_release(this.handle));
        this.handle = 0L;
    }

    public boolean isAnalogAutomaticGainControlEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_get_analog_automatic_gain_control_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioFilters setAnalogAutomaticGainControlEnabled(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_set_analog_automatic_gain_control_enabled(this.handle, value));
        return this;
    }

    public boolean isDigitalAutomaticGainControlEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_get_digital_automatic_gain_control_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioFilters setDigitalAutomaticGainControlEnabled(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_set_digital_automatic_gain_control_enabled(this.handle, value));
        return this;
    }

    public NoiseSuppressionMode getNoiseSuppressionMode() {
        Out<NoiseSuppressionMode> result = new Out<NoiseSuppressionMode>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_get_noise_suppression_mode(this.handle, result));
        return (NoiseSuppressionMode)((Object)result.value);
    }

    public OutgoingAudioFilters setNoiseSuppressionMode(NoiseSuppressionMode value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_set_noise_suppression_mode(this.handle, value));
        return this;
    }

    public boolean isMusicModeEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_get_music_mode_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioFilters setMusicModeEnabled(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_set_music_mode_enabled(this.handle, value));
        return this;
    }

    public boolean isAcousticEchoCancellationEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_get_acoustic_echo_cancellation_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    public OutgoingAudioFilters setAcousticEchoCancellationEnabled(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_audio_filters_set_acoustic_echo_cancellation_enabled(this.handle, value));
        return this;
    }

    static OutgoingAudioFilters getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingAudioFilters, OutgoingAudioFilters.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_audio_filters_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingAudioFilters, OutgoingAudioFilters.class, false);
    }
}

