/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.Status;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;

class NativeLibraryHelpers {
    NativeLibraryHelpers() {
    }

    static void checkStatus(Status value) {
        if (value == Status.OK) {
            return;
        }
        String fullMessage = "";
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, "", "", "");
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, "", "", "");
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, "", "", "");
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, "", "", "");
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, "", "", "");
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, "", "", "");
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, "", "", "");
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, "", "", "");
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, "", "", "");
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, "", "", "");
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, "", "", "");
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, "", "", "");
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, "", "", "");
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, "", "", "");
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, "", "", "");
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, "", "", "");
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, "", "", "");
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, "", "", "");
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, "", "", "");
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, "", "", "");
            }
            case DUPLICATE_DEVICE_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, "", "", "");
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, "", "", "");
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, "", "", "");
            }
            case INVALID_VIDEO_FORMAT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, "", "", "");
            }
            case INVALID_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, "", "", "");
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, "", "", "");
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, "", "", "");
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, "", "", "");
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, "", "", "");
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, "", "", "");
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, "", "", "");
            }
            case CAPTIONS_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, "", "", "");
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case CAPTIONS_POLICY_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, "", "", "");
            }
            case CAPTIONS_NOT_ACTIVE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, "", "", "");
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, "", "", "");
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, "", "", "");
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, "", "", "");
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, "", "", "");
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, "", "", "");
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, "", "", "");
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, "", "", "");
            }
            case GET_CAPTIONS_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, "", "", "");
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case MAX_SPOTLIGHT_REACHED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, "", "", "");
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, "", "", "");
            }
            case SIGNALING_OPERATION_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, "", "", "");
            }
            case MUSIC_MODE_NOT_ENABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, "", "", "");
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, "", "", "");
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, "", "", "");
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, "", "", "");
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, "", "", "");
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, "", "", "");
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, "", "", "");
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, "", "", "");
            }
        }
    }

    static void checkStatus(long handle, Status value) {
        String fullMessage;
        if (value == Status.OK) {
            return;
        }
        Out<String> outParam_message = new Out<String>();
        Out<String> outParam_requestCorrelationVector = new Out<String>();
        Out<String> outParam_responseCorrelationVector = new Out<String>();
        Status code = NativeLibrary.sam_get_error_details(handle, outParam_message, outParam_requestCorrelationVector, outParam_responseCorrelationVector);
        if (code == Status.FAILED) {
            throw new IllegalStateException("Unexpected error in exception handling.");
        }
        if (code != Status.OK) {
            fullMessage = "Exception thrown and an unexpected error in exception handling.";
        } else {
            fullMessage = (String)outParam_message.value + ".";
            if (outParam_requestCorrelationVector.value != null && !((String)outParam_requestCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Request CV: " + (String)outParam_requestCorrelationVector.value + ".";
            }
            if (outParam_responseCorrelationVector.value != null && !((String)outParam_responseCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Response CV: " + (String)outParam_responseCorrelationVector.value + ".";
            }
        }
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DUPLICATE_DEVICE_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_VIDEO_FORMAT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_POLICY_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_NOT_ACTIVE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case GET_CAPTIONS_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MAX_SPOTLIGHT_REACHED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SIGNALING_OPERATION_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUSIC_MODE_NOT_ENABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
        }
    }
}

