/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CallState;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;

class ModeInCommunicationHelper {
    private static String TAG = "ModeInCommunicationHelper";

    ModeInCommunicationHelper() {
    }

    static void setModeInCommunication(final Context context, final Call call) {
        PropertyChangedListener callStateChangedListener = new PropertyChangedListener(){

            @Override
            @SuppressLint(value={"LongLogTag"})
            public void onPropertyChanged(PropertyChangedEvent args) {
                if (call.getState() == CallState.CONNECTED) {
                    Log.i((String)TAG, (String)"Enabling AudioManager.MODE_IN_COMMUNICATION on Call Connected");
                    AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                    audioManager.setMode(3);
                } else if (call.getState() == CallState.DISCONNECTED) {
                    Log.i((String)TAG, (String)"Enabling AudioManager.MODE_NORMAL on Call Disconnected");
                    AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                    audioManager.setMode(0);
                    if (call != null) {
                        call.removeOnStateChangedListener(this);
                    }
                }
            }
        };
        call.addOnStateChangedListener(callStateChangedListener);
    }
}

