/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.MediaDiagnosticType;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.Date;

public final class MediaDiagnosticValues {
    long handle;

    MediaDiagnosticValues(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_media_diagnostic_values_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostic_values_release(this.handle));
        this.handle = 0L;
    }

    public Date getLastUpdatedAt() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostic_values_get_last_updated_at(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    private boolean getValueInternal(MediaDiagnosticType diagnostic) {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_media_diagnostic_values_get_value_internal(this.handle, diagnostic, result));
        return (Boolean)result.value;
    }

    static MediaDiagnosticValues getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaDiagnosticValues, MediaDiagnosticValues.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_media_diagnostic_values_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.MediaDiagnosticValues, MediaDiagnosticValues.class, false);
    }

    private Boolean getBoolValueIfExists(MediaDiagnosticType diagnostic) {
        try {
            return this.getValueInternal(diagnostic);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public Boolean isSpeakerNotFunctioning() {
        return this.getBoolValueIfExists(MediaDiagnosticType.SPEAKER_NOT_FUNCTIONING);
    }

    public Boolean isSpeakerBusy() {
        return this.getBoolValueIfExists(MediaDiagnosticType.SPEAKER_NOT_FUNCTIONING_DEVICE_IN_USE);
    }

    public Boolean isSpeakerMuted() {
        return this.getBoolValueIfExists(MediaDiagnosticType.SPEAKER_MUTED);
    }

    public Boolean isSpeakerVolumeZero() {
        return this.getBoolValueIfExists(MediaDiagnosticType.SPEAKER_VOLUME_ZERO);
    }

    public Boolean isNoSpeakerDevicesAvailable() {
        return this.getBoolValueIfExists(MediaDiagnosticType.NO_SPEAKER_DEVICES_ENUMERATED);
    }

    public Boolean isSpeakingWhileMicrophoneIsMuted() {
        return this.getBoolValueIfExists(MediaDiagnosticType.SPEAKING_WHILE_MICROPHONE_IS_MUTED);
    }

    public Boolean isNoMicrophoneDevicesAvailable() {
        return this.getBoolValueIfExists(MediaDiagnosticType.NO_MICROPHONE_DEVICES_ENUMERATED);
    }

    public Boolean isMicrophoneBusy() {
        return this.getBoolValueIfExists(MediaDiagnosticType.MICROPHONE_NOT_FUNCTIONING_DEVICE_IN_USE);
    }

    public Boolean isCameraFrozen() {
        return this.getBoolValueIfExists(MediaDiagnosticType.CAMERA_FREEZE);
    }

    public Boolean isCameraStartFailed() {
        return this.getBoolValueIfExists(MediaDiagnosticType.CAMERA_START_FAILED);
    }

    public Boolean isCameraStartTimedOut() {
        return this.getBoolValueIfExists(MediaDiagnosticType.CAMERA_START_TIMED_OUT);
    }

    public Boolean isMicrophoneNotFunctioning() {
        return this.getBoolValueIfExists(MediaDiagnosticType.MICROPHONE_NOT_FUNCTIONING);
    }

    public Boolean isMicrophoneMutedUnexpectedly() {
        return this.getBoolValueIfExists(MediaDiagnosticType.MICROPHONE_MUTED_UNEXPECTEDLY);
    }

    public Boolean isCameraPermissionDenied() {
        return this.getBoolValueIfExists(MediaDiagnosticType.CAMERA_PERMISSION_DENIED);
    }
}

