/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.TextureView;
import com.azure.android.communication.calling.CameraFacing;
import com.azure.android.communication.calling.DeviceProfile;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.calling.VideoStreamView;

class LocalOutgoingVideoStreamView
extends VideoStreamView
implements TextureView.SurfaceTextureListener,
VideoOrientationManager.OrientationChangedCallback {
    private static final String TAG = "LocalOutgoingVideoStreamView";
    private LocalVideoStream localVideoStream;
    private VideoOrientationManager orientationManager;
    private CameraFacing cameraFacing;
    private int originalW = 0;
    private int originalH = 0;

    LocalOutgoingVideoStreamView(Context context, LocalVideoStream localVideoStream, ScalingMode scalingMode) {
        super(context, -1, scalingMode);
        this.localVideoStream = localVideoStream;
        this.cameraFacing = localVideoStream.getSource().getCameraFacing();
        this.orientationManager = VideoOrientationManager.getInstance(context);
        this.orientationManager.addCallback(this);
        this.orientationManager.start();
    }

    void Init(int previewVideoId) {
        if (this.surfaceTexture == null) {
            this.videoId = previewVideoId;
            Log.debug1(TAG, "Init previewVideoId: %d", this.videoId);
            this.textureView = new TextureView(this.context);
            this.textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.textureView.setVisibility(0);
            this.textureView.layout(0, 0, this.getRight(), this.getBottom());
            this.AddTextureView();
        } else {
            this.RegisterSurfaceTexture();
        }
    }

    private void FixVideoFrameSize() {
        this.w = this.originalW;
        this.h = this.originalH;
        int orientation = this.orientationManager.getOrientation();
        int cameraOrientation = DeviceProfile.GetCameraOrientation(this.cameraFacing);
        if ((cameraOrientation == 90 || cameraOrientation == 270) && orientation != 90 && orientation != 270) {
            this.w = this.originalH;
            this.h = this.originalW;
            Log.debug1(TAG, "Video frame size rotated, new w: %d x h: %d, camera orientation: %d, orientation: %d", this.w, this.h, cameraOrientation, orientation);
        }
        this.streamSize = new StreamSize(this.w, this.h);
    }

    void UpdateVideoFrameSize(int w, int h) {
        int orientation = this.orientationManager.getOrientation();
        Log.debug1(TAG, "UpdateVideoFrameSize new w: %d x h: %d, old w: %d x h: %d, orientation: %d", w, h, this.originalW, this.originalH, orientation);
        this.originalW = w;
        this.originalH = h;
        this.FixVideoFrameSize();
        this.ScaleTextureView();
    }

    void RegisterSurfaceTexture() {
        if (this.surfaceTexture != null) {
            this.localVideoStream.registerView(this.surfaceTexture);
            Log.debug1(TAG, "Registering SurfaceTexture: %d to previewVideoId: %d", System.identityHashCode(this.surfaceTexture), this.videoId);
        }
        this.ScaleTextureView();
    }

    void UnregisterSurfaceTexture() {
        if (this.surfaceTexture != null) {
            this.localVideoStream.unregisterView();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int w, int h) {
        Log.debug1(TAG, "onSurfaceTextureAvailable previewVideoId: %d", this.videoId);
        this.surfaceTexture = surfaceTexture;
        this.RegisterSurfaceTexture();
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        if (this.surfaceTexture != surfaceTexture) {
            Log.debug1(TAG, "onSurfaceTextureUpdated previewVideoId: %d", this.videoId);
            this.surfaceTexture = surfaceTexture;
            this.RegisterSurfaceTexture();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        Log.debug1(TAG, "onSurfaceTextureDestroyed previewVideoId: %d", this.videoId);
        this.UnregisterSurfaceTexture();
        this.CleanSurfaceTexture();
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int w, int h) {
        Log.debug1(TAG, "onSurfaceTextureSizeChanged previewVideoId: %d", this.videoId);
        this.ScaleTextureView();
    }

    @Override
    public void onOrientationChanged(int orientation) {
        Log.debug1(TAG, "onOrientationChanged previewVideoId: %d orientation: %d", this.videoId, orientation);
        this.FixVideoFrameSize();
        this.ScaleTextureView();
    }

    private void CleanSurfaceTexture() {
        if (this.surfaceTexture != null) {
            Log.debug1(TAG, "Releasing SurfaceTexture", new Object[0]);
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
    }

    public void Dispose() {
        Log.debug1(TAG, "Dispose", new Object[0]);
        if (this.orientationManager != null) {
            this.orientationManager.removeCallback(this);
            this.orientationManager.stop();
            this.orientationManager = null;
        }
        this.UnregisterSurfaceTexture();
        this.CleanSurfaceTexture();
        this.RemoveTextureView();
    }
}

