/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamStateChangedEvent;
import com.azure.android.communication.calling.AudioStreamStateChangedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioStream;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.Status;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LocalOutgoingAudioStream
extends OutgoingAudioStream {
    private List<AudioStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<AudioStreamStateChangedListener>();

    LocalOutgoingAudioStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    LocalOutgoingAudioStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_local_outgoing_audio_stream_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public LocalOutgoingAudioStream() {
        super(LocalOutgoingAudioStream.Create(), true);
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        LocalOutgoingAudioStream instance = LocalOutgoingAudioStream.getInstance(cookie);
        if (instance != null) {
            AudioStreamStateChangedEvent args_converted = args != 0L ? AudioStreamStateChangedEvent.getInstance(args, false) : null;
            for (AudioStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onAudioStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_outgoing_audio_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_outgoing_audio_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    static LocalOutgoingAudioStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalOutgoingAudioStream, LocalOutgoingAudioStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_audio_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalOutgoingAudioStream, LocalOutgoingAudioStream.class, false);
    }

    private static LocalOutgoingAudioStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalOutgoingAudioStream, LocalOutgoingAudioStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((AudioStreamStateChangedListener)eventListener);
        }
    }
}

