/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CallOptions;
import com.azure.android.communication.calling.IncomingAudioOptions;
import com.azure.android.communication.calling.IncomingVideoOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.OutgoingVideoOptions;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoOptions;

public final class JoinCallOptions
extends CallOptions {
    JoinCallOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_join_call_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public JoinCallOptions() {
        super(JoinCallOptions.Create(), true);
    }

    @Deprecated
    public VideoOptions getVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_join_call_options_get_video_options(this.handle, result_handle));
        VideoOptions result_object = (Long)result_handle.value != 0L ? VideoOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    @Deprecated
    public JoinCallOptions setVideoOptions(VideoOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_join_call_options_set_video_options(this.handle, value_converted));
        return this;
    }

    @Deprecated
    public AudioOptions getAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_join_call_options_get_audio_options(this.handle, result_handle));
        AudioOptions result_object = (Long)result_handle.value != 0L ? AudioOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    @Deprecated
    public JoinCallOptions setAudioOptions(AudioOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_join_call_options_set_audio_options(this.handle, value_converted));
        return this;
    }

    @Override
    public JoinCallOptions setIncomingVideoOptions(IncomingVideoOptions value) {
        super.setIncomingVideoOptions(value);
        return this;
    }

    @Override
    public JoinCallOptions setOutgoingVideoOptions(OutgoingVideoOptions value) {
        super.setOutgoingVideoOptions(value);
        return this;
    }

    @Override
    public JoinCallOptions setIncomingAudioOptions(IncomingAudioOptions value) {
        super.setIncomingAudioOptions(value);
        return this;
    }

    @Override
    public JoinCallOptions setOutgoingAudioOptions(OutgoingAudioOptions value) {
        super.setOutgoingAudioOptions(value);
        return this;
    }

    static JoinCallOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.JoinCallOptions, JoinCallOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.JoinCallOptions, JoinCallOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

